<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLpuRecipe ArrayType
 * @subpackage Arrays
 */
class ArrayOfLpuRecipe extends AbstractStructArrayBase
{
    /**
     * The LpuRecipe
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LpuRecipe[]
     */
    public $LpuRecipe;
    /**
     * Constructor method for ArrayOfLpuRecipe
     * @uses ArrayOfLpuRecipe::setLpuRecipe()
     * @param \StructType\LpuRecipe[] $lpuRecipe
     */
    public function __construct(array $lpuRecipe = array())
    {
        $this
            ->setLpuRecipe($lpuRecipe);
    }
    /**
     * Get LpuRecipe value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LpuRecipe[]|null
     */
    public function getLpuRecipe()
    {
        return isset($this->LpuRecipe) ? $this->LpuRecipe : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLpuRecipe method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLpuRecipe method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLpuRecipeForArrayConstraintsFromSetLpuRecipe(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfLpuRecipeLpuRecipeItem) {
            // validation for constraint: itemType
            if (!$arrayOfLpuRecipeLpuRecipeItem instanceof \StructType\LpuRecipe) {
                $invalidValues[] = is_object($arrayOfLpuRecipeLpuRecipeItem) ? get_class($arrayOfLpuRecipeLpuRecipeItem) : sprintf('%s(%s)', gettype($arrayOfLpuRecipeLpuRecipeItem), var_export($arrayOfLpuRecipeLpuRecipeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LpuRecipe property can only contain items of type \StructType\LpuRecipe, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LpuRecipe value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\LpuRecipe[] $lpuRecipe
     * @return \ArrayType\ArrayOfLpuRecipe
     */
    public function setLpuRecipe(array $lpuRecipe = array())
    {
        // validation for constraint: array
        if ('' !== ($lpuRecipeArrayErrorMessage = self::validateLpuRecipeForArrayConstraintsFromSetLpuRecipe($lpuRecipe))) {
            throw new \InvalidArgumentException($lpuRecipeArrayErrorMessage, __LINE__);
        }
        if (is_null($lpuRecipe) || (is_array($lpuRecipe) && empty($lpuRecipe))) {
            unset($this->LpuRecipe);
        } else {
            $this->LpuRecipe = $lpuRecipe;
        }
        return $this;
    }
    /**
     * Add item to LpuRecipe value
     * @throws \InvalidArgumentException
     * @param \StructType\LpuRecipe $item
     * @return \ArrayType\ArrayOfLpuRecipe
     */
    public function addToLpuRecipe(\StructType\LpuRecipe $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LpuRecipe) {
            throw new \InvalidArgumentException(sprintf('The LpuRecipe property can only contain items of type \StructType\LpuRecipe, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LpuRecipe[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\LpuRecipe|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\LpuRecipe|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\LpuRecipe|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\LpuRecipe|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\LpuRecipe|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string LpuRecipe
     */
    public function getAttributeName()
    {
        return 'LpuRecipe';
    }
}
