<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDocumentHash ArrayType
 * @subpackage Arrays
 */
class ArrayOfDocumentHash extends AbstractStructArrayBase
{
    /**
     * The DocumentHash
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DocumentHash[]
     */
    public $DocumentHash;
    /**
     * Constructor method for ArrayOfDocumentHash
     * @uses ArrayOfDocumentHash::setDocumentHash()
     * @param \StructType\DocumentHash[] $documentHash
     */
    public function __construct(array $documentHash = array())
    {
        $this
            ->setDocumentHash($documentHash);
    }
    /**
     * Get DocumentHash value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DocumentHash[]|null
     */
    public function getDocumentHash()
    {
        return isset($this->DocumentHash) ? $this->DocumentHash : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDocumentHash method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocumentHash method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentHashForArrayConstraintsFromSetDocumentHash(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDocumentHashDocumentHashItem) {
            // validation for constraint: itemType
            if (!$arrayOfDocumentHashDocumentHashItem instanceof \StructType\DocumentHash) {
                $invalidValues[] = is_object($arrayOfDocumentHashDocumentHashItem) ? get_class($arrayOfDocumentHashDocumentHashItem) : sprintf('%s(%s)', gettype($arrayOfDocumentHashDocumentHashItem), var_export($arrayOfDocumentHashDocumentHashItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DocumentHash property can only contain items of type \StructType\DocumentHash, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DocumentHash value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentHash[] $documentHash
     * @return \ArrayType\ArrayOfDocumentHash
     */
    public function setDocumentHash(array $documentHash = array())
    {
        // validation for constraint: array
        if ('' !== ($documentHashArrayErrorMessage = self::validateDocumentHashForArrayConstraintsFromSetDocumentHash($documentHash))) {
            throw new \InvalidArgumentException($documentHashArrayErrorMessage, __LINE__);
        }
        if (is_null($documentHash) || (is_array($documentHash) && empty($documentHash))) {
            unset($this->DocumentHash);
        } else {
            $this->DocumentHash = $documentHash;
        }
        return $this;
    }
    /**
     * Add item to DocumentHash value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentHash $item
     * @return \ArrayType\ArrayOfDocumentHash
     */
    public function addToDocumentHash(\StructType\DocumentHash $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DocumentHash) {
            throw new \InvalidArgumentException(sprintf('The DocumentHash property can only contain items of type \StructType\DocumentHash, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DocumentHash[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DocumentHash|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DocumentHash|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DocumentHash|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DocumentHash|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DocumentHash|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DocumentHash
     */
    public function getAttributeName()
    {
        return 'DocumentHash';
    }
}
