<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Recipe ServiceType
 */
$recipe = new \ServiceType\Recipe($options);
/**
 * Sample call for RecipeRequest operation/method
 */
if ($recipe->RecipeRequest(new \StructType\RecipeRequest()) !== false) {
    print_r($recipe->getResult());
} else {
    print_r($recipe->getLastError());
}
/**
 * Sample call for RecipeRequest2 operation/method
 */
if ($recipe->RecipeRequest2(new \StructType\RecipeRequest2()) !== false) {
    print_r($recipe->getResult());
} else {
    print_r($recipe->getLastError());
}
/**
 * Sample call for RecipeRequestRepeat operation/method
 */
if ($recipe->RecipeRequestRepeat(new \StructType\RecipeRequestRepeat()) !== false) {
    print_r($recipe->getResult());
} else {
    print_r($recipe->getLastError());
}
/**
 * Sample call for RecipeResponse operation/method
 */
if ($recipe->RecipeResponse(new \StructType\RecipeResponse()) !== false) {
    print_r($recipe->getResult());
} else {
    print_r($recipe->getLastError());
}
/**
 * Sample call for RecipeFind operation/method
 */
if ($recipe->RecipeFind(new \StructType\RecipeFind()) !== false) {
    print_r($recipe->getResult());
} else {
    print_r($recipe->getLastError());
}
/**
 * Sample call for RecipeCheck operation/method
 */
if ($recipe->RecipeCheck(new \StructType\RecipeCheck()) !== false) {
    print_r($recipe->getResult());
} else {
    print_r($recipe->getLastError());
}
/**
 * Sample call for RecipeEditCheck operation/method
 */
if ($recipe->RecipeEditCheck(new \StructType\RecipeEditCheck()) !== false) {
    print_r($recipe->getResult());
} else {
    print_r($recipe->getLastError());
}
/**
 * Sample call for RecipeDelay operation/method
 */
if ($recipe->RecipeDelay(new \StructType\RecipeDelay()) !== false) {
    print_r($recipe->getResult());
} else {
    print_r($recipe->getLastError());
}
/**
 * Sample call for RecipeClientSave operation/method
 */
if ($recipe->RecipeClientSave(new \StructType\RecipeClientSave()) !== false) {
    print_r($recipe->getResult());
} else {
    print_r($recipe->getLastError());
}
/**
 * Sample call for RecipeReestrRequest operation/method
 */
if ($recipe->RecipeReestrRequest(new \StructType\RecipeReestrRequest()) !== false) {
    print_r($recipe->getResult());
} else {
    print_r($recipe->getLastError());
}
/**
 * Samples for Lpu ServiceType
 */
$lpu = new \ServiceType\Lpu($options);
/**
 * Sample call for LpuRecipeRequest operation/method
 */
if ($lpu->LpuRecipeRequest(new \StructType\LpuRecipeRequest()) !== false) {
    print_r($lpu->getResult());
} else {
    print_r($lpu->getLastError());
}
/**
 * Samples for Recipes ServiceType
 */
$recipes = new \ServiceType\Recipes($options);
/**
 * Sample call for RecipesClientSave operation/method
 */
if ($recipes->RecipesClientSave(new \StructType\RecipesClientSave()) !== false) {
    print_r($recipes->getResult());
} else {
    print_r($recipes->getLastError());
}
/**
 * Sample call for RecipesClient2Save operation/method
 */
if ($recipes->RecipesClient2Save(new \StructType\RecipesClient2Save()) !== false) {
    print_r($recipes->getResult());
} else {
    print_r($recipes->getLastError());
}
/**
 * Sample call for RecipesClientHashesExchange operation/method
 */
if ($recipes->RecipesClientHashesExchange(new \StructType\RecipesClientHashesExchange()) !== false) {
    print_r($recipes->getResult());
} else {
    print_r($recipes->getLastError());
}
