<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecipeResponse StructType
 * @subpackage Structs
 */
class RecipeResponse extends AbstractStructBase
{
    /**
     * The clientId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $clientId;
    /**
     * The recipes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRecipeResponseInfo
     */
    public $recipes;
    /**
     * Constructor method for RecipeResponse
     * @uses RecipeResponse::setClientId()
     * @uses RecipeResponse::setRecipes()
     * @param string $clientId
     * @param \ArrayType\ArrayOfRecipeResponseInfo $recipes
     */
    public function __construct($clientId = null, \ArrayType\ArrayOfRecipeResponseInfo $recipes = null)
    {
        $this
            ->setClientId($clientId)
            ->setRecipes($recipes);
    }
    /**
     * Get clientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->clientId;
    }
    /**
     * Set clientId value
     * @param string $clientId
     * @return \StructType\RecipeResponse
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        $this->clientId = $clientId;
        return $this;
    }
    /**
     * Get recipes value
     * @return \ArrayType\ArrayOfRecipeResponseInfo|null
     */
    public function getRecipes()
    {
        return $this->recipes;
    }
    /**
     * Set recipes value
     * @param \ArrayType\ArrayOfRecipeResponseInfo $recipes
     * @return \StructType\RecipeResponse
     */
    public function setRecipes(\ArrayType\ArrayOfRecipeResponseInfo $recipes = null)
    {
        $this->recipes = $recipes;
        return $this;
    }
}
