<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecipeReestr StructType
 * @subpackage Structs
 */
class RecipeReestr extends Entity
{
    /**
     * The ReestrGuid
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $ReestrGuid;
    /**
     * The ReestrItemGuid
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $ReestrItemGuid;
    /**
     * The ReestrItemDetailGuid
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $ReestrItemDetailGuid;
    /**
     * The IdChequeItemGlobal
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $IdChequeItemGlobal;
    /**
     * The ReestrDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReestrDate;
    /**
     * The ReestrNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReestrNumber;
    /**
     * The ReestrState
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReestrState;
    /**
     * The ReestrItemDetailState
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReestrItemDetailState;
    /**
     * The Deleted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Deleted;
    /**
     * Constructor method for RecipeReestr
     * @uses RecipeReestr::setReestrGuid()
     * @uses RecipeReestr::setReestrItemGuid()
     * @uses RecipeReestr::setReestrItemDetailGuid()
     * @uses RecipeReestr::setIdChequeItemGlobal()
     * @uses RecipeReestr::setReestrDate()
     * @uses RecipeReestr::setReestrNumber()
     * @uses RecipeReestr::setReestrState()
     * @uses RecipeReestr::setReestrItemDetailState()
     * @uses RecipeReestr::setDeleted()
     * @param string $reestrGuid
     * @param string $reestrItemGuid
     * @param string $reestrItemDetailGuid
     * @param string $idChequeItemGlobal
     * @param string $reestrDate
     * @param string $reestrNumber
     * @param string $reestrState
     * @param string $reestrItemDetailState
     * @param string $deleted
     */
    public function __construct($reestrGuid = null, $reestrItemGuid = null, $reestrItemDetailGuid = null, $idChequeItemGlobal = null, $reestrDate = null, $reestrNumber = null, $reestrState = null, $reestrItemDetailState = null, $deleted = null)
    {
        $this
            ->setReestrGuid($reestrGuid)
            ->setReestrItemGuid($reestrItemGuid)
            ->setReestrItemDetailGuid($reestrItemDetailGuid)
            ->setIdChequeItemGlobal($idChequeItemGlobal)
            ->setReestrDate($reestrDate)
            ->setReestrNumber($reestrNumber)
            ->setReestrState($reestrState)
            ->setReestrItemDetailState($reestrItemDetailState)
            ->setDeleted($deleted);
    }
    /**
     * Get ReestrGuid value
     * @return string|null
     */
    public function getReestrGuid()
    {
        return $this->ReestrGuid;
    }
    /**
     * Set ReestrGuid value
     * @param string $reestrGuid
     * @return \StructType\RecipeReestr
     */
    public function setReestrGuid($reestrGuid = null)
    {
        // validation for constraint: string
        if (!is_null($reestrGuid) && !is_string($reestrGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reestrGuid, true), gettype($reestrGuid)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($reestrGuid) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $reestrGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($reestrGuid, true)), __LINE__);
        }
        $this->ReestrGuid = $reestrGuid;
        return $this;
    }
    /**
     * Get ReestrItemGuid value
     * @return string|null
     */
    public function getReestrItemGuid()
    {
        return $this->ReestrItemGuid;
    }
    /**
     * Set ReestrItemGuid value
     * @param string $reestrItemGuid
     * @return \StructType\RecipeReestr
     */
    public function setReestrItemGuid($reestrItemGuid = null)
    {
        // validation for constraint: string
        if (!is_null($reestrItemGuid) && !is_string($reestrItemGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reestrItemGuid, true), gettype($reestrItemGuid)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($reestrItemGuid) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $reestrItemGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($reestrItemGuid, true)), __LINE__);
        }
        $this->ReestrItemGuid = $reestrItemGuid;
        return $this;
    }
    /**
     * Get ReestrItemDetailGuid value
     * @return string|null
     */
    public function getReestrItemDetailGuid()
    {
        return $this->ReestrItemDetailGuid;
    }
    /**
     * Set ReestrItemDetailGuid value
     * @param string $reestrItemDetailGuid
     * @return \StructType\RecipeReestr
     */
    public function setReestrItemDetailGuid($reestrItemDetailGuid = null)
    {
        // validation for constraint: string
        if (!is_null($reestrItemDetailGuid) && !is_string($reestrItemDetailGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reestrItemDetailGuid, true), gettype($reestrItemDetailGuid)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($reestrItemDetailGuid) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $reestrItemDetailGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($reestrItemDetailGuid, true)), __LINE__);
        }
        $this->ReestrItemDetailGuid = $reestrItemDetailGuid;
        return $this;
    }
    /**
     * Get IdChequeItemGlobal value
     * @return string|null
     */
    public function getIdChequeItemGlobal()
    {
        return $this->IdChequeItemGlobal;
    }
    /**
     * Set IdChequeItemGlobal value
     * @param string $idChequeItemGlobal
     * @return \StructType\RecipeReestr
     */
    public function setIdChequeItemGlobal($idChequeItemGlobal = null)
    {
        // validation for constraint: string
        if (!is_null($idChequeItemGlobal) && !is_string($idChequeItemGlobal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idChequeItemGlobal, true), gettype($idChequeItemGlobal)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($idChequeItemGlobal) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $idChequeItemGlobal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($idChequeItemGlobal, true)), __LINE__);
        }
        $this->IdChequeItemGlobal = $idChequeItemGlobal;
        return $this;
    }
    /**
     * Get ReestrDate value
     * @return string|null
     */
    public function getReestrDate()
    {
        return $this->ReestrDate;
    }
    /**
     * Set ReestrDate value
     * @param string $reestrDate
     * @return \StructType\RecipeReestr
     */
    public function setReestrDate($reestrDate = null)
    {
        // validation for constraint: string
        if (!is_null($reestrDate) && !is_string($reestrDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reestrDate, true), gettype($reestrDate)), __LINE__);
        }
        $this->ReestrDate = $reestrDate;
        return $this;
    }
    /**
     * Get ReestrNumber value
     * @return string|null
     */
    public function getReestrNumber()
    {
        return $this->ReestrNumber;
    }
    /**
     * Set ReestrNumber value
     * @param string $reestrNumber
     * @return \StructType\RecipeReestr
     */
    public function setReestrNumber($reestrNumber = null)
    {
        // validation for constraint: string
        if (!is_null($reestrNumber) && !is_string($reestrNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reestrNumber, true), gettype($reestrNumber)), __LINE__);
        }
        $this->ReestrNumber = $reestrNumber;
        return $this;
    }
    /**
     * Get ReestrState value
     * @return string|null
     */
    public function getReestrState()
    {
        return $this->ReestrState;
    }
    /**
     * Set ReestrState value
     * @param string $reestrState
     * @return \StructType\RecipeReestr
     */
    public function setReestrState($reestrState = null)
    {
        // validation for constraint: string
        if (!is_null($reestrState) && !is_string($reestrState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reestrState, true), gettype($reestrState)), __LINE__);
        }
        $this->ReestrState = $reestrState;
        return $this;
    }
    /**
     * Get ReestrItemDetailState value
     * @return string|null
     */
    public function getReestrItemDetailState()
    {
        return $this->ReestrItemDetailState;
    }
    /**
     * Set ReestrItemDetailState value
     * @param string $reestrItemDetailState
     * @return \StructType\RecipeReestr
     */
    public function setReestrItemDetailState($reestrItemDetailState = null)
    {
        // validation for constraint: string
        if (!is_null($reestrItemDetailState) && !is_string($reestrItemDetailState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reestrItemDetailState, true), gettype($reestrItemDetailState)), __LINE__);
        }
        $this->ReestrItemDetailState = $reestrItemDetailState;
        return $this;
    }
    /**
     * Get Deleted value
     * @return string|null
     */
    public function getDeleted()
    {
        return $this->Deleted;
    }
    /**
     * Set Deleted value
     * @param string $deleted
     * @return \StructType\RecipeReestr
     */
    public function setDeleted($deleted = null)
    {
        // validation for constraint: string
        if (!is_null($deleted) && !is_string($deleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deleted, true), gettype($deleted)), __LINE__);
        }
        $this->Deleted = $deleted;
        return $this;
    }
}
