<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecipeFind StructType
 * @subpackage Structs
 */
class RecipeFind extends AbstractStructBase
{
    /**
     * The saleDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $saleDate;
    /**
     * The clientId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $clientId;
    /**
     * The seria
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $seria;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $number;
    /**
     * Constructor method for RecipeFind
     * @uses RecipeFind::setSaleDate()
     * @uses RecipeFind::setClientId()
     * @uses RecipeFind::setSeria()
     * @uses RecipeFind::setNumber()
     * @param string $saleDate
     * @param string $clientId
     * @param string $seria
     * @param string $number
     */
    public function __construct($saleDate = null, $clientId = null, $seria = null, $number = null)
    {
        $this
            ->setSaleDate($saleDate)
            ->setClientId($clientId)
            ->setSeria($seria)
            ->setNumber($number);
    }
    /**
     * Get saleDate value
     * @return string
     */
    public function getSaleDate()
    {
        return $this->saleDate;
    }
    /**
     * Set saleDate value
     * @param string $saleDate
     * @return \StructType\RecipeFind
     */
    public function setSaleDate($saleDate = null)
    {
        // validation for constraint: string
        if (!is_null($saleDate) && !is_string($saleDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleDate, true), gettype($saleDate)), __LINE__);
        }
        $this->saleDate = $saleDate;
        return $this;
    }
    /**
     * Get clientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->clientId;
    }
    /**
     * Set clientId value
     * @param string $clientId
     * @return \StructType\RecipeFind
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        $this->clientId = $clientId;
        return $this;
    }
    /**
     * Get seria value
     * @return string|null
     */
    public function getSeria()
    {
        return $this->seria;
    }
    /**
     * Set seria value
     * @param string $seria
     * @return \StructType\RecipeFind
     */
    public function setSeria($seria = null)
    {
        // validation for constraint: string
        if (!is_null($seria) && !is_string($seria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seria, true), gettype($seria)), __LINE__);
        }
        $this->seria = $seria;
        return $this;
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\RecipeFind
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
}
