<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecipeEditCheck StructType
 * @subpackage Structs
 */
class RecipeEditCheck extends AbstractStructBase
{
    /**
     * The clientId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $clientId;
    /**
     * The recipeInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RecipeResponseInfo
     */
    public $recipeInfo;
    /**
     * Constructor method for RecipeEditCheck
     * @uses RecipeEditCheck::setClientId()
     * @uses RecipeEditCheck::setRecipeInfo()
     * @param string $clientId
     * @param \StructType\RecipeResponseInfo $recipeInfo
     */
    public function __construct($clientId = null, \StructType\RecipeResponseInfo $recipeInfo = null)
    {
        $this
            ->setClientId($clientId)
            ->setRecipeInfo($recipeInfo);
    }
    /**
     * Get clientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->clientId;
    }
    /**
     * Set clientId value
     * @param string $clientId
     * @return \StructType\RecipeEditCheck
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        $this->clientId = $clientId;
        return $this;
    }
    /**
     * Get recipeInfo value
     * @return \StructType\RecipeResponseInfo|null
     */
    public function getRecipeInfo()
    {
        return $this->recipeInfo;
    }
    /**
     * Set recipeInfo value
     * @param \StructType\RecipeResponseInfo $recipeInfo
     * @return \StructType\RecipeEditCheck
     */
    public function setRecipeInfo(\StructType\RecipeResponseInfo $recipeInfo = null)
    {
        $this->recipeInfo = $recipeInfo;
        return $this;
    }
}
