<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecipeDelay StructType
 * @subpackage Structs
 */
class RecipeDelay extends AbstractStructBase
{
    /**
     * The incomeDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $incomeDate;
    /**
     * The clientId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $clientId;
    /**
     * The seria
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $seria;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $number;
    /**
     * Constructor method for RecipeDelay
     * @uses RecipeDelay::setIncomeDate()
     * @uses RecipeDelay::setClientId()
     * @uses RecipeDelay::setSeria()
     * @uses RecipeDelay::setNumber()
     * @param string $incomeDate
     * @param string $clientId
     * @param string $seria
     * @param string $number
     */
    public function __construct($incomeDate = null, $clientId = null, $seria = null, $number = null)
    {
        $this
            ->setIncomeDate($incomeDate)
            ->setClientId($clientId)
            ->setSeria($seria)
            ->setNumber($number);
    }
    /**
     * Get incomeDate value
     * @return string
     */
    public function getIncomeDate()
    {
        return $this->incomeDate;
    }
    /**
     * Set incomeDate value
     * @param string $incomeDate
     * @return \StructType\RecipeDelay
     */
    public function setIncomeDate($incomeDate = null)
    {
        // validation for constraint: string
        if (!is_null($incomeDate) && !is_string($incomeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($incomeDate, true), gettype($incomeDate)), __LINE__);
        }
        $this->incomeDate = $incomeDate;
        return $this;
    }
    /**
     * Get clientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->clientId;
    }
    /**
     * Set clientId value
     * @param string $clientId
     * @return \StructType\RecipeDelay
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        $this->clientId = $clientId;
        return $this;
    }
    /**
     * Get seria value
     * @return string|null
     */
    public function getSeria()
    {
        return $this->seria;
    }
    /**
     * Set seria value
     * @param string $seria
     * @return \StructType\RecipeDelay
     */
    public function setSeria($seria = null)
    {
        // validation for constraint: string
        if (!is_null($seria) && !is_string($seria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seria, true), gettype($seria)), __LINE__);
        }
        $this->seria = $seria;
        return $this;
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\RecipeDelay
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
}
