<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecipeClient2 StructType
 * @subpackage Structs
 */
class RecipeClient2 extends Entity
{
    /**
     * The DocumentStateId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DocumentStateId;
    /**
     * The Seria
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Seria;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Number;
    /**
     * The DocumentDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentDate;
    /**
     * The CauseOfAnnulmentCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CauseOfAnnulmentCode;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Note;
    /**
     * The IssueInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RecipeClient2Issue
     */
    public $IssueInfo;
    /**
     * The SaleInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RecipeClient2Sale
     */
    public $SaleInfo;
    /**
     * Constructor method for RecipeClient2
     * @uses RecipeClient2::setDocumentStateId()
     * @uses RecipeClient2::setSeria()
     * @uses RecipeClient2::setNumber()
     * @uses RecipeClient2::setDocumentDate()
     * @uses RecipeClient2::setCauseOfAnnulmentCode()
     * @uses RecipeClient2::setNote()
     * @uses RecipeClient2::setIssueInfo()
     * @uses RecipeClient2::setSaleInfo()
     * @param int $documentStateId
     * @param string $seria
     * @param string $number
     * @param string $documentDate
     * @param int $causeOfAnnulmentCode
     * @param string $note
     * @param \StructType\RecipeClient2Issue $issueInfo
     * @param \StructType\RecipeClient2Sale $saleInfo
     */
    public function __construct($documentStateId = null, $seria = null, $number = null, $documentDate = null, $causeOfAnnulmentCode = null, $note = null, \StructType\RecipeClient2Issue $issueInfo = null, \StructType\RecipeClient2Sale $saleInfo = null)
    {
        $this
            ->setDocumentStateId($documentStateId)
            ->setSeria($seria)
            ->setNumber($number)
            ->setDocumentDate($documentDate)
            ->setCauseOfAnnulmentCode($causeOfAnnulmentCode)
            ->setNote($note)
            ->setIssueInfo($issueInfo)
            ->setSaleInfo($saleInfo);
    }
    /**
     * Get DocumentStateId value
     * @return int
     */
    public function getDocumentStateId()
    {
        return $this->DocumentStateId;
    }
    /**
     * Set DocumentStateId value
     * @param int $documentStateId
     * @return \StructType\RecipeClient2
     */
    public function setDocumentStateId($documentStateId = null)
    {
        // validation for constraint: int
        if (!is_null($documentStateId) && !(is_int($documentStateId) || ctype_digit($documentStateId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentStateId, true), gettype($documentStateId)), __LINE__);
        }
        $this->DocumentStateId = $documentStateId;
        return $this;
    }
    /**
     * Get Seria value
     * @return string|null
     */
    public function getSeria()
    {
        return $this->Seria;
    }
    /**
     * Set Seria value
     * @param string $seria
     * @return \StructType\RecipeClient2
     */
    public function setSeria($seria = null)
    {
        // validation for constraint: string
        if (!is_null($seria) && !is_string($seria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seria, true), gettype($seria)), __LINE__);
        }
        $this->Seria = $seria;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \StructType\RecipeClient2
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get DocumentDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentDate()
    {
        return isset($this->DocumentDate) ? $this->DocumentDate : null;
    }
    /**
     * Set DocumentDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentDate
     * @return \StructType\RecipeClient2
     */
    public function setDocumentDate($documentDate = null)
    {
        // validation for constraint: string
        if (!is_null($documentDate) && !is_string($documentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentDate, true), gettype($documentDate)), __LINE__);
        }
        if (is_null($documentDate) || (is_array($documentDate) && empty($documentDate))) {
            unset($this->DocumentDate);
        } else {
            $this->DocumentDate = $documentDate;
        }
        return $this;
    }
    /**
     * Get CauseOfAnnulmentCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCauseOfAnnulmentCode()
    {
        return isset($this->CauseOfAnnulmentCode) ? $this->CauseOfAnnulmentCode : null;
    }
    /**
     * Set CauseOfAnnulmentCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $causeOfAnnulmentCode
     * @return \StructType\RecipeClient2
     */
    public function setCauseOfAnnulmentCode($causeOfAnnulmentCode = null)
    {
        // validation for constraint: int
        if (!is_null($causeOfAnnulmentCode) && !(is_int($causeOfAnnulmentCode) || ctype_digit($causeOfAnnulmentCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($causeOfAnnulmentCode, true), gettype($causeOfAnnulmentCode)), __LINE__);
        }
        if (is_null($causeOfAnnulmentCode) || (is_array($causeOfAnnulmentCode) && empty($causeOfAnnulmentCode))) {
            unset($this->CauseOfAnnulmentCode);
        } else {
            $this->CauseOfAnnulmentCode = $causeOfAnnulmentCode;
        }
        return $this;
    }
    /**
     * Get Note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @param string $note
     * @return \StructType\RecipeClient2
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        $this->Note = $note;
        return $this;
    }
    /**
     * Get IssueInfo value
     * @return \StructType\RecipeClient2Issue|null
     */
    public function getIssueInfo()
    {
        return $this->IssueInfo;
    }
    /**
     * Set IssueInfo value
     * @param \StructType\RecipeClient2Issue $issueInfo
     * @return \StructType\RecipeClient2
     */
    public function setIssueInfo(\StructType\RecipeClient2Issue $issueInfo = null)
    {
        $this->IssueInfo = $issueInfo;
        return $this;
    }
    /**
     * Get SaleInfo value
     * @return \StructType\RecipeClient2Sale|null
     */
    public function getSaleInfo()
    {
        return $this->SaleInfo;
    }
    /**
     * Set SaleInfo value
     * @param \StructType\RecipeClient2Sale $saleInfo
     * @return \StructType\RecipeClient2
     */
    public function setSaleInfo(\StructType\RecipeClient2Sale $saleInfo = null)
    {
        $this->SaleInfo = $saleInfo;
        return $this;
    }
}
