<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recipe StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Recipe
 * @subpackage Structs
 */
class Recipe extends Entity
{
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Quantity;
    /**
     * The QuantityElements
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $QuantityElements;
    /**
     * The PackageSize
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PackageSize;
    /**
     * The Denominator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Denominator;
    /**
     * The Credit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Credit;
    /**
     * The AllowRecipeReserveMultiSupplier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AllowRecipeReserveMultiSupplier;
    /**
     * The AllowRecipeReserveMultiGoscontract
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AllowRecipeReserveMultiGoscontract;
    /**
     * The IsSigned
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSigned;
    /**
     * The Seria
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Seria;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Number;
    /**
     * The Fio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fio;
    /**
     * The UnifyId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnifyId;
    /**
     * The UnifyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnifyName;
    /**
     * The UnifyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnifyCode;
    /**
     * The TradeName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TradeName;
    /**
     * The NonproprietaryName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NonproprietaryName;
    /**
     * The Dosage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Dosage;
    /**
     * The CureForm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CureForm;
    /**
     * The CureFormId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CureFormId;
    /**
     * The IdLotGlobal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IdLotGlobal;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExpirationDate;
    /**
     * The Invalid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invalid;
    /**
     * The RecipeReserveInfos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRecipeReserveInfo
     */
    public $RecipeReserveInfos;
    /**
     * The MnnItems
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfMnnItem
     */
    public $MnnItems;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IssueDate;
    /**
     * The FeldsherPointMcod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FeldsherPointMcod;
    /**
     * The DrugstoreSoldId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DrugstoreSoldId;
    /**
     * The IndividualId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IndividualId;
    /**
     * The PrivilegeCategoryCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrivilegeCategoryCode;
    /**
     * The ValidPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ValidPeriod;
    /**
     * The MoOgrn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MoOgrn;
    /**
     * The MoMcod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MoMcod;
    /**
     * The DoctorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DoctorCode;
    /**
     * The MkbCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MkbCode;
    /**
     * Constructor method for Recipe
     * @uses Recipe::setQuantity()
     * @uses Recipe::setQuantityElements()
     * @uses Recipe::setPackageSize()
     * @uses Recipe::setDenominator()
     * @uses Recipe::setCredit()
     * @uses Recipe::setAllowRecipeReserveMultiSupplier()
     * @uses Recipe::setAllowRecipeReserveMultiGoscontract()
     * @uses Recipe::setIsSigned()
     * @uses Recipe::setSeria()
     * @uses Recipe::setNumber()
     * @uses Recipe::setFio()
     * @uses Recipe::setUnifyId()
     * @uses Recipe::setUnifyName()
     * @uses Recipe::setUnifyCode()
     * @uses Recipe::setTradeName()
     * @uses Recipe::setNonproprietaryName()
     * @uses Recipe::setDosage()
     * @uses Recipe::setCureForm()
     * @uses Recipe::setCureFormId()
     * @uses Recipe::setIdLotGlobal()
     * @uses Recipe::setExpirationDate()
     * @uses Recipe::setInvalid()
     * @uses Recipe::setRecipeReserveInfos()
     * @uses Recipe::setMnnItems()
     * @uses Recipe::setId()
     * @uses Recipe::setIssueDate()
     * @uses Recipe::setFeldsherPointMcod()
     * @uses Recipe::setDrugstoreSoldId()
     * @uses Recipe::setIndividualId()
     * @uses Recipe::setPrivilegeCategoryCode()
     * @uses Recipe::setValidPeriod()
     * @uses Recipe::setMoOgrn()
     * @uses Recipe::setMoMcod()
     * @uses Recipe::setDoctorCode()
     * @uses Recipe::setMkbCode()
     * @param float $quantity
     * @param float $quantityElements
     * @param int $packageSize
     * @param int $denominator
     * @param float $credit
     * @param bool $allowRecipeReserveMultiSupplier
     * @param bool $allowRecipeReserveMultiGoscontract
     * @param bool $isSigned
     * @param string $seria
     * @param string $number
     * @param string $fio
     * @param string $unifyId
     * @param string $unifyName
     * @param string $unifyCode
     * @param string $tradeName
     * @param string $nonproprietaryName
     * @param string $dosage
     * @param string $cureForm
     * @param string $cureFormId
     * @param string $idLotGlobal
     * @param string $expirationDate
     * @param string $invalid
     * @param \ArrayType\ArrayOfRecipeReserveInfo $recipeReserveInfos
     * @param \ArrayType\ArrayOfMnnItem $mnnItems
     * @param string $id
     * @param string $issueDate
     * @param string $feldsherPointMcod
     * @param string $drugstoreSoldId
     * @param string $individualId
     * @param string $privilegeCategoryCode
     * @param string $validPeriod
     * @param string $moOgrn
     * @param string $moMcod
     * @param string $doctorCode
     * @param string $mkbCode
     */
    public function __construct($quantity = null, $quantityElements = null, $packageSize = null, $denominator = null, $credit = null, $allowRecipeReserveMultiSupplier = null, $allowRecipeReserveMultiGoscontract = null, $isSigned = null, $seria = null, $number = null, $fio = null, $unifyId = null, $unifyName = null, $unifyCode = null, $tradeName = null, $nonproprietaryName = null, $dosage = null, $cureForm = null, $cureFormId = null, $idLotGlobal = null, $expirationDate = null, $invalid = null, \ArrayType\ArrayOfRecipeReserveInfo $recipeReserveInfos = null, \ArrayType\ArrayOfMnnItem $mnnItems = null, $id = null, $issueDate = null, $feldsherPointMcod = null, $drugstoreSoldId = null, $individualId = null, $privilegeCategoryCode = null, $validPeriod = null, $moOgrn = null, $moMcod = null, $doctorCode = null, $mkbCode = null)
    {
        $this
            ->setQuantity($quantity)
            ->setQuantityElements($quantityElements)
            ->setPackageSize($packageSize)
            ->setDenominator($denominator)
            ->setCredit($credit)
            ->setAllowRecipeReserveMultiSupplier($allowRecipeReserveMultiSupplier)
            ->setAllowRecipeReserveMultiGoscontract($allowRecipeReserveMultiGoscontract)
            ->setIsSigned($isSigned)
            ->setSeria($seria)
            ->setNumber($number)
            ->setFio($fio)
            ->setUnifyId($unifyId)
            ->setUnifyName($unifyName)
            ->setUnifyCode($unifyCode)
            ->setTradeName($tradeName)
            ->setNonproprietaryName($nonproprietaryName)
            ->setDosage($dosage)
            ->setCureForm($cureForm)
            ->setCureFormId($cureFormId)
            ->setIdLotGlobal($idLotGlobal)
            ->setExpirationDate($expirationDate)
            ->setInvalid($invalid)
            ->setRecipeReserveInfos($recipeReserveInfos)
            ->setMnnItems($mnnItems)
            ->setId($id)
            ->setIssueDate($issueDate)
            ->setFeldsherPointMcod($feldsherPointMcod)
            ->setDrugstoreSoldId($drugstoreSoldId)
            ->setIndividualId($individualId)
            ->setPrivilegeCategoryCode($privilegeCategoryCode)
            ->setValidPeriod($validPeriod)
            ->setMoOgrn($moOgrn)
            ->setMoMcod($moMcod)
            ->setDoctorCode($doctorCode)
            ->setMkbCode($mkbCode);
    }
    /**
     * Get Quantity value
     * @return float
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\Recipe
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get QuantityElements value
     * @return float
     */
    public function getQuantityElements()
    {
        return $this->QuantityElements;
    }
    /**
     * Set QuantityElements value
     * @param float $quantityElements
     * @return \StructType\Recipe
     */
    public function setQuantityElements($quantityElements = null)
    {
        // validation for constraint: float
        if (!is_null($quantityElements) && !(is_float($quantityElements) || is_numeric($quantityElements))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityElements, true), gettype($quantityElements)), __LINE__);
        }
        $this->QuantityElements = $quantityElements;
        return $this;
    }
    /**
     * Get PackageSize value
     * @return int
     */
    public function getPackageSize()
    {
        return $this->PackageSize;
    }
    /**
     * Set PackageSize value
     * @param int $packageSize
     * @return \StructType\Recipe
     */
    public function setPackageSize($packageSize = null)
    {
        // validation for constraint: int
        if (!is_null($packageSize) && !(is_int($packageSize) || ctype_digit($packageSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($packageSize, true), gettype($packageSize)), __LINE__);
        }
        $this->PackageSize = $packageSize;
        return $this;
    }
    /**
     * Get Denominator value
     * @return int
     */
    public function getDenominator()
    {
        return $this->Denominator;
    }
    /**
     * Set Denominator value
     * @param int $denominator
     * @return \StructType\Recipe
     */
    public function setDenominator($denominator = null)
    {
        // validation for constraint: int
        if (!is_null($denominator) && !(is_int($denominator) || ctype_digit($denominator))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($denominator, true), gettype($denominator)), __LINE__);
        }
        $this->Denominator = $denominator;
        return $this;
    }
    /**
     * Get Credit value
     * @return float
     */
    public function getCredit()
    {
        return $this->Credit;
    }
    /**
     * Set Credit value
     * @param float $credit
     * @return \StructType\Recipe
     */
    public function setCredit($credit = null)
    {
        // validation for constraint: float
        if (!is_null($credit) && !(is_float($credit) || is_numeric($credit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($credit, true), gettype($credit)), __LINE__);
        }
        $this->Credit = $credit;
        return $this;
    }
    /**
     * Get AllowRecipeReserveMultiSupplier value
     * @return bool
     */
    public function getAllowRecipeReserveMultiSupplier()
    {
        return $this->AllowRecipeReserveMultiSupplier;
    }
    /**
     * Set AllowRecipeReserveMultiSupplier value
     * @param bool $allowRecipeReserveMultiSupplier
     * @return \StructType\Recipe
     */
    public function setAllowRecipeReserveMultiSupplier($allowRecipeReserveMultiSupplier = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowRecipeReserveMultiSupplier) && !is_bool($allowRecipeReserveMultiSupplier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowRecipeReserveMultiSupplier, true), gettype($allowRecipeReserveMultiSupplier)), __LINE__);
        }
        $this->AllowRecipeReserveMultiSupplier = $allowRecipeReserveMultiSupplier;
        return $this;
    }
    /**
     * Get AllowRecipeReserveMultiGoscontract value
     * @return bool
     */
    public function getAllowRecipeReserveMultiGoscontract()
    {
        return $this->AllowRecipeReserveMultiGoscontract;
    }
    /**
     * Set AllowRecipeReserveMultiGoscontract value
     * @param bool $allowRecipeReserveMultiGoscontract
     * @return \StructType\Recipe
     */
    public function setAllowRecipeReserveMultiGoscontract($allowRecipeReserveMultiGoscontract = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowRecipeReserveMultiGoscontract) && !is_bool($allowRecipeReserveMultiGoscontract)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowRecipeReserveMultiGoscontract, true), gettype($allowRecipeReserveMultiGoscontract)), __LINE__);
        }
        $this->AllowRecipeReserveMultiGoscontract = $allowRecipeReserveMultiGoscontract;
        return $this;
    }
    /**
     * Get IsSigned value
     * @return bool
     */
    public function getIsSigned()
    {
        return $this->IsSigned;
    }
    /**
     * Set IsSigned value
     * @param bool $isSigned
     * @return \StructType\Recipe
     */
    public function setIsSigned($isSigned = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSigned) && !is_bool($isSigned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSigned, true), gettype($isSigned)), __LINE__);
        }
        $this->IsSigned = $isSigned;
        return $this;
    }
    /**
     * Get Seria value
     * @return string|null
     */
    public function getSeria()
    {
        return $this->Seria;
    }
    /**
     * Set Seria value
     * @param string $seria
     * @return \StructType\Recipe
     */
    public function setSeria($seria = null)
    {
        // validation for constraint: string
        if (!is_null($seria) && !is_string($seria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seria, true), gettype($seria)), __LINE__);
        }
        $this->Seria = $seria;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \StructType\Recipe
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Fio value
     * @return string|null
     */
    public function getFio()
    {
        return $this->Fio;
    }
    /**
     * Set Fio value
     * @param string $fio
     * @return \StructType\Recipe
     */
    public function setFio($fio = null)
    {
        // validation for constraint: string
        if (!is_null($fio) && !is_string($fio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fio, true), gettype($fio)), __LINE__);
        }
        $this->Fio = $fio;
        return $this;
    }
    /**
     * Get UnifyId value
     * @return string|null
     */
    public function getUnifyId()
    {
        return $this->UnifyId;
    }
    /**
     * Set UnifyId value
     * @param string $unifyId
     * @return \StructType\Recipe
     */
    public function setUnifyId($unifyId = null)
    {
        // validation for constraint: string
        if (!is_null($unifyId) && !is_string($unifyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unifyId, true), gettype($unifyId)), __LINE__);
        }
        $this->UnifyId = $unifyId;
        return $this;
    }
    /**
     * Get UnifyName value
     * @return string|null
     */
    public function getUnifyName()
    {
        return $this->UnifyName;
    }
    /**
     * Set UnifyName value
     * @param string $unifyName
     * @return \StructType\Recipe
     */
    public function setUnifyName($unifyName = null)
    {
        // validation for constraint: string
        if (!is_null($unifyName) && !is_string($unifyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unifyName, true), gettype($unifyName)), __LINE__);
        }
        $this->UnifyName = $unifyName;
        return $this;
    }
    /**
     * Get UnifyCode value
     * @return string|null
     */
    public function getUnifyCode()
    {
        return $this->UnifyCode;
    }
    /**
     * Set UnifyCode value
     * @param string $unifyCode
     * @return \StructType\Recipe
     */
    public function setUnifyCode($unifyCode = null)
    {
        // validation for constraint: string
        if (!is_null($unifyCode) && !is_string($unifyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unifyCode, true), gettype($unifyCode)), __LINE__);
        }
        $this->UnifyCode = $unifyCode;
        return $this;
    }
    /**
     * Get TradeName value
     * @return string|null
     */
    public function getTradeName()
    {
        return $this->TradeName;
    }
    /**
     * Set TradeName value
     * @param string $tradeName
     * @return \StructType\Recipe
     */
    public function setTradeName($tradeName = null)
    {
        // validation for constraint: string
        if (!is_null($tradeName) && !is_string($tradeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tradeName, true), gettype($tradeName)), __LINE__);
        }
        $this->TradeName = $tradeName;
        return $this;
    }
    /**
     * Get NonproprietaryName value
     * @return string|null
     */
    public function getNonproprietaryName()
    {
        return $this->NonproprietaryName;
    }
    /**
     * Set NonproprietaryName value
     * @param string $nonproprietaryName
     * @return \StructType\Recipe
     */
    public function setNonproprietaryName($nonproprietaryName = null)
    {
        // validation for constraint: string
        if (!is_null($nonproprietaryName) && !is_string($nonproprietaryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nonproprietaryName, true), gettype($nonproprietaryName)), __LINE__);
        }
        $this->NonproprietaryName = $nonproprietaryName;
        return $this;
    }
    /**
     * Get Dosage value
     * @return string|null
     */
    public function getDosage()
    {
        return $this->Dosage;
    }
    /**
     * Set Dosage value
     * @param string $dosage
     * @return \StructType\Recipe
     */
    public function setDosage($dosage = null)
    {
        // validation for constraint: string
        if (!is_null($dosage) && !is_string($dosage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dosage, true), gettype($dosage)), __LINE__);
        }
        $this->Dosage = $dosage;
        return $this;
    }
    /**
     * Get CureForm value
     * @return string|null
     */
    public function getCureForm()
    {
        return $this->CureForm;
    }
    /**
     * Set CureForm value
     * @param string $cureForm
     * @return \StructType\Recipe
     */
    public function setCureForm($cureForm = null)
    {
        // validation for constraint: string
        if (!is_null($cureForm) && !is_string($cureForm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cureForm, true), gettype($cureForm)), __LINE__);
        }
        $this->CureForm = $cureForm;
        return $this;
    }
    /**
     * Get CureFormId value
     * @return string|null
     */
    public function getCureFormId()
    {
        return $this->CureFormId;
    }
    /**
     * Set CureFormId value
     * @param string $cureFormId
     * @return \StructType\Recipe
     */
    public function setCureFormId($cureFormId = null)
    {
        // validation for constraint: string
        if (!is_null($cureFormId) && !is_string($cureFormId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cureFormId, true), gettype($cureFormId)), __LINE__);
        }
        $this->CureFormId = $cureFormId;
        return $this;
    }
    /**
     * Get IdLotGlobal value
     * @return string|null
     */
    public function getIdLotGlobal()
    {
        return $this->IdLotGlobal;
    }
    /**
     * Set IdLotGlobal value
     * @param string $idLotGlobal
     * @return \StructType\Recipe
     */
    public function setIdLotGlobal($idLotGlobal = null)
    {
        // validation for constraint: string
        if (!is_null($idLotGlobal) && !is_string($idLotGlobal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idLotGlobal, true), gettype($idLotGlobal)), __LINE__);
        }
        $this->IdLotGlobal = $idLotGlobal;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param string $expirationDate
     * @return \StructType\Recipe
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get Invalid value
     * @return string|null
     */
    public function getInvalid()
    {
        return $this->Invalid;
    }
    /**
     * Set Invalid value
     * @param string $invalid
     * @return \StructType\Recipe
     */
    public function setInvalid($invalid = null)
    {
        // validation for constraint: string
        if (!is_null($invalid) && !is_string($invalid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invalid, true), gettype($invalid)), __LINE__);
        }
        $this->Invalid = $invalid;
        return $this;
    }
    /**
     * Get RecipeReserveInfos value
     * @return \ArrayType\ArrayOfRecipeReserveInfo|null
     */
    public function getRecipeReserveInfos()
    {
        return $this->RecipeReserveInfos;
    }
    /**
     * Set RecipeReserveInfos value
     * @param \ArrayType\ArrayOfRecipeReserveInfo $recipeReserveInfos
     * @return \StructType\Recipe
     */
    public function setRecipeReserveInfos(\ArrayType\ArrayOfRecipeReserveInfo $recipeReserveInfos = null)
    {
        $this->RecipeReserveInfos = $recipeReserveInfos;
        return $this;
    }
    /**
     * Get MnnItems value
     * @return \ArrayType\ArrayOfMnnItem|null
     */
    public function getMnnItems()
    {
        return $this->MnnItems;
    }
    /**
     * Set MnnItems value
     * @param \ArrayType\ArrayOfMnnItem $mnnItems
     * @return \StructType\Recipe
     */
    public function setMnnItems(\ArrayType\ArrayOfMnnItem $mnnItems = null)
    {
        $this->MnnItems = $mnnItems;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\Recipe
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get IssueDate value
     * @return string|null
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param string $issueDate
     * @return \StructType\Recipe
     */
    public function setIssueDate($issueDate = null)
    {
        // validation for constraint: string
        if (!is_null($issueDate) && !is_string($issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueDate, true), gettype($issueDate)), __LINE__);
        }
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get FeldsherPointMcod value
     * @return string|null
     */
    public function getFeldsherPointMcod()
    {
        return $this->FeldsherPointMcod;
    }
    /**
     * Set FeldsherPointMcod value
     * @param string $feldsherPointMcod
     * @return \StructType\Recipe
     */
    public function setFeldsherPointMcod($feldsherPointMcod = null)
    {
        // validation for constraint: string
        if (!is_null($feldsherPointMcod) && !is_string($feldsherPointMcod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feldsherPointMcod, true), gettype($feldsherPointMcod)), __LINE__);
        }
        $this->FeldsherPointMcod = $feldsherPointMcod;
        return $this;
    }
    /**
     * Get DrugstoreSoldId value
     * @return string|null
     */
    public function getDrugstoreSoldId()
    {
        return $this->DrugstoreSoldId;
    }
    /**
     * Set DrugstoreSoldId value
     * @param string $drugstoreSoldId
     * @return \StructType\Recipe
     */
    public function setDrugstoreSoldId($drugstoreSoldId = null)
    {
        // validation for constraint: string
        if (!is_null($drugstoreSoldId) && !is_string($drugstoreSoldId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($drugstoreSoldId, true), gettype($drugstoreSoldId)), __LINE__);
        }
        $this->DrugstoreSoldId = $drugstoreSoldId;
        return $this;
    }
    /**
     * Get IndividualId value
     * @return string|null
     */
    public function getIndividualId()
    {
        return $this->IndividualId;
    }
    /**
     * Set IndividualId value
     * @param string $individualId
     * @return \StructType\Recipe
     */
    public function setIndividualId($individualId = null)
    {
        // validation for constraint: string
        if (!is_null($individualId) && !is_string($individualId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($individualId, true), gettype($individualId)), __LINE__);
        }
        $this->IndividualId = $individualId;
        return $this;
    }
    /**
     * Get PrivilegeCategoryCode value
     * @return string|null
     */
    public function getPrivilegeCategoryCode()
    {
        return $this->PrivilegeCategoryCode;
    }
    /**
     * Set PrivilegeCategoryCode value
     * @param string $privilegeCategoryCode
     * @return \StructType\Recipe
     */
    public function setPrivilegeCategoryCode($privilegeCategoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($privilegeCategoryCode) && !is_string($privilegeCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($privilegeCategoryCode, true), gettype($privilegeCategoryCode)), __LINE__);
        }
        $this->PrivilegeCategoryCode = $privilegeCategoryCode;
        return $this;
    }
    /**
     * Get ValidPeriod value
     * @return string|null
     */
    public function getValidPeriod()
    {
        return $this->ValidPeriod;
    }
    /**
     * Set ValidPeriod value
     * @param string $validPeriod
     * @return \StructType\Recipe
     */
    public function setValidPeriod($validPeriod = null)
    {
        // validation for constraint: string
        if (!is_null($validPeriod) && !is_string($validPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validPeriod, true), gettype($validPeriod)), __LINE__);
        }
        $this->ValidPeriod = $validPeriod;
        return $this;
    }
    /**
     * Get MoOgrn value
     * @return string|null
     */
    public function getMoOgrn()
    {
        return $this->MoOgrn;
    }
    /**
     * Set MoOgrn value
     * @param string $moOgrn
     * @return \StructType\Recipe
     */
    public function setMoOgrn($moOgrn = null)
    {
        // validation for constraint: string
        if (!is_null($moOgrn) && !is_string($moOgrn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($moOgrn, true), gettype($moOgrn)), __LINE__);
        }
        $this->MoOgrn = $moOgrn;
        return $this;
    }
    /**
     * Get MoMcod value
     * @return string|null
     */
    public function getMoMcod()
    {
        return $this->MoMcod;
    }
    /**
     * Set MoMcod value
     * @param string $moMcod
     * @return \StructType\Recipe
     */
    public function setMoMcod($moMcod = null)
    {
        // validation for constraint: string
        if (!is_null($moMcod) && !is_string($moMcod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($moMcod, true), gettype($moMcod)), __LINE__);
        }
        $this->MoMcod = $moMcod;
        return $this;
    }
    /**
     * Get DoctorCode value
     * @return string|null
     */
    public function getDoctorCode()
    {
        return $this->DoctorCode;
    }
    /**
     * Set DoctorCode value
     * @param string $doctorCode
     * @return \StructType\Recipe
     */
    public function setDoctorCode($doctorCode = null)
    {
        // validation for constraint: string
        if (!is_null($doctorCode) && !is_string($doctorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doctorCode, true), gettype($doctorCode)), __LINE__);
        }
        $this->DoctorCode = $doctorCode;
        return $this;
    }
    /**
     * Get MkbCode value
     * @return string|null
     */
    public function getMkbCode()
    {
        return $this->MkbCode;
    }
    /**
     * Set MkbCode value
     * @param string $mkbCode
     * @return \StructType\Recipe
     */
    public function setMkbCode($mkbCode = null)
    {
        // validation for constraint: string
        if (!is_null($mkbCode) && !is_string($mkbCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mkbCode, true), gettype($mkbCode)), __LINE__);
        }
        $this->MkbCode = $mkbCode;
        return $this;
    }
}
