<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Item StructType
 * @subpackage Structs
 */
class Item extends AbstractStructBase
{
    /**
     * The ProductCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductCode;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Quantity;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Price;
    /**
     * The BestBefore
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BestBefore;
    /**
     * The StoreId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StoreId;
    /**
     * The ProductSeria
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductSeria;
    /**
     * The ContractNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContractNumber;
    /**
     * Constructor method for Item
     * @uses Item::setProductCode()
     * @uses Item::setQuantity()
     * @uses Item::setPrice()
     * @uses Item::setBestBefore()
     * @uses Item::setStoreId()
     * @uses Item::setProductSeria()
     * @uses Item::setContractNumber()
     * @param int $productCode
     * @param float $quantity
     * @param float $price
     * @param string $bestBefore
     * @param int $storeId
     * @param string $productSeria
     * @param string $contractNumber
     */
    public function __construct($productCode = null, $quantity = null, $price = null, $bestBefore = null, $storeId = null, $productSeria = null, $contractNumber = null)
    {
        $this
            ->setProductCode($productCode)
            ->setQuantity($quantity)
            ->setPrice($price)
            ->setBestBefore($bestBefore)
            ->setStoreId($storeId)
            ->setProductSeria($productSeria)
            ->setContractNumber($contractNumber);
    }
    /**
     * Get ProductCode value
     * @return int
     */
    public function getProductCode()
    {
        return $this->ProductCode;
    }
    /**
     * Set ProductCode value
     * @param int $productCode
     * @return \StructType\Item
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: int
        if (!is_null($productCode) && !(is_int($productCode) || ctype_digit($productCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productCode, true), gettype($productCode)), __LINE__);
        }
        $this->ProductCode = $productCode;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\Item
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Price value
     * @return float
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\Item
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Get BestBefore value
     * @return string
     */
    public function getBestBefore()
    {
        return $this->BestBefore;
    }
    /**
     * Set BestBefore value
     * @param string $bestBefore
     * @return \StructType\Item
     */
    public function setBestBefore($bestBefore = null)
    {
        // validation for constraint: string
        if (!is_null($bestBefore) && !is_string($bestBefore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bestBefore, true), gettype($bestBefore)), __LINE__);
        }
        $this->BestBefore = $bestBefore;
        return $this;
    }
    /**
     * Get StoreId value
     * @return int
     */
    public function getStoreId()
    {
        return $this->StoreId;
    }
    /**
     * Set StoreId value
     * @param int $storeId
     * @return \StructType\Item
     */
    public function setStoreId($storeId = null)
    {
        // validation for constraint: int
        if (!is_null($storeId) && !(is_int($storeId) || ctype_digit($storeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($storeId, true), gettype($storeId)), __LINE__);
        }
        $this->StoreId = $storeId;
        return $this;
    }
    /**
     * Get ProductSeria value
     * @return string|null
     */
    public function getProductSeria()
    {
        return $this->ProductSeria;
    }
    /**
     * Set ProductSeria value
     * @param string $productSeria
     * @return \StructType\Item
     */
    public function setProductSeria($productSeria = null)
    {
        // validation for constraint: string
        if (!is_null($productSeria) && !is_string($productSeria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productSeria, true), gettype($productSeria)), __LINE__);
        }
        $this->ProductSeria = $productSeria;
        return $this;
    }
    /**
     * Get ContractNumber value
     * @return string|null
     */
    public function getContractNumber()
    {
        return $this->ContractNumber;
    }
    /**
     * Set ContractNumber value
     * @param string $contractNumber
     * @return \StructType\Item
     */
    public function setContractNumber($contractNumber = null)
    {
        // validation for constraint: string
        if (!is_null($contractNumber) && !is_string($contractNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractNumber, true), gettype($contractNumber)), __LINE__);
        }
        $this->ContractNumber = $contractNumber;
        return $this;
    }
}
