<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Recipe ServiceType
 * @subpackage Services
 */
class Recipe extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RecipeRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RecipeRequest $parameters
     * @return \StructType\RecipeRequestResponse|bool
     */
    public function RecipeRequest(\StructType\RecipeRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RecipeRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RecipeRequest2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RecipeRequest2 $parameters
     * @return \StructType\RecipeRequest2Response|bool
     */
    public function RecipeRequest2(\StructType\RecipeRequest2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RecipeRequest2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RecipeRequestRepeat
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RecipeRequestRepeat $parameters
     * @return \StructType\RecipeRequestRepeatResponse|bool
     */
    public function RecipeRequestRepeat(\StructType\RecipeRequestRepeat $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RecipeRequestRepeat($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RecipeResponse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RecipeResponse $parameters
     * @return \StructType\RecipeResponseResponse|bool
     */
    public function RecipeResponse(\StructType\RecipeResponse $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RecipeResponse($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RecipeFind
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RecipeFind $parameters
     * @return \StructType\RecipeFindResponse|bool
     */
    public function RecipeFind(\StructType\RecipeFind $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RecipeFind($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RecipeCheck
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RecipeCheck $parameters
     * @return \StructType\RecipeCheckResponse|bool
     */
    public function RecipeCheck(\StructType\RecipeCheck $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RecipeCheck($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RecipeEditCheck
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RecipeEditCheck $parameters
     * @return \StructType\RecipeEditCheckResponse|bool
     */
    public function RecipeEditCheck(\StructType\RecipeEditCheck $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RecipeEditCheck($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RecipeDelay
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RecipeDelay $parameters
     * @return \StructType\RecipeDelayResponse|bool
     */
    public function RecipeDelay(\StructType\RecipeDelay $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RecipeDelay($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RecipeClientSave
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RecipeClientSave $parameters
     * @return \StructType\RecipeClientSaveResponse|bool
     */
    public function RecipeClientSave(\StructType\RecipeClientSave $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RecipeClientSave($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RecipeReestrRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RecipeReestrRequest $parameters
     * @return \StructType\RecipeReestrRequestResponse|bool
     */
    public function RecipeReestrRequest(\StructType\RecipeReestrRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RecipeReestrRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RecipeCheckResponse|\StructType\RecipeClientSaveResponse|\StructType\RecipeDelayResponse|\StructType\RecipeEditCheckResponse|\StructType\RecipeFindResponse|\StructType\RecipeReestrRequestResponse|\StructType\RecipeRequest2Response|\StructType\RecipeRequestRepeatResponse|\StructType\RecipeRequestResponse|\StructType\RecipeResponseResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
