<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRecipeResponseInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfRecipeResponseInfo extends AbstractStructArrayBase
{
    /**
     * The RecipeResponseInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RecipeResponseInfo[]
     */
    public $RecipeResponseInfo;
    /**
     * Constructor method for ArrayOfRecipeResponseInfo
     * @uses ArrayOfRecipeResponseInfo::setRecipeResponseInfo()
     * @param \StructType\RecipeResponseInfo[] $recipeResponseInfo
     */
    public function __construct(array $recipeResponseInfo = array())
    {
        $this
            ->setRecipeResponseInfo($recipeResponseInfo);
    }
    /**
     * Get RecipeResponseInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RecipeResponseInfo[]|null
     */
    public function getRecipeResponseInfo()
    {
        return isset($this->RecipeResponseInfo) ? $this->RecipeResponseInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRecipeResponseInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecipeResponseInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecipeResponseInfoForArrayConstraintsFromSetRecipeResponseInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfRecipeResponseInfoRecipeResponseInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfRecipeResponseInfoRecipeResponseInfoItem instanceof \StructType\RecipeResponseInfo) {
                $invalidValues[] = is_object($arrayOfRecipeResponseInfoRecipeResponseInfoItem) ? get_class($arrayOfRecipeResponseInfoRecipeResponseInfoItem) : sprintf('%s(%s)', gettype($arrayOfRecipeResponseInfoRecipeResponseInfoItem), var_export($arrayOfRecipeResponseInfoRecipeResponseInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RecipeResponseInfo property can only contain items of type \StructType\RecipeResponseInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RecipeResponseInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RecipeResponseInfo[] $recipeResponseInfo
     * @return \ArrayType\ArrayOfRecipeResponseInfo
     */
    public function setRecipeResponseInfo(array $recipeResponseInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($recipeResponseInfoArrayErrorMessage = self::validateRecipeResponseInfoForArrayConstraintsFromSetRecipeResponseInfo($recipeResponseInfo))) {
            throw new \InvalidArgumentException($recipeResponseInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($recipeResponseInfo) || (is_array($recipeResponseInfo) && empty($recipeResponseInfo))) {
            unset($this->RecipeResponseInfo);
        } else {
            $this->RecipeResponseInfo = $recipeResponseInfo;
        }
        return $this;
    }
    /**
     * Add item to RecipeResponseInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\RecipeResponseInfo $item
     * @return \ArrayType\ArrayOfRecipeResponseInfo
     */
    public function addToRecipeResponseInfo(\StructType\RecipeResponseInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RecipeResponseInfo) {
            throw new \InvalidArgumentException(sprintf('The RecipeResponseInfo property can only contain items of type \StructType\RecipeResponseInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RecipeResponseInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RecipeResponseInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RecipeResponseInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RecipeResponseInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RecipeResponseInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RecipeResponseInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RecipeResponseInfo
     */
    public function getAttributeName()
    {
        return 'RecipeResponseInfo';
    }
}
