<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRecipeReserveInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfRecipeReserveInfo extends AbstractStructArrayBase
{
    /**
     * The RecipeReserveInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RecipeReserveInfo[]
     */
    public $RecipeReserveInfo;
    /**
     * Constructor method for ArrayOfRecipeReserveInfo
     * @uses ArrayOfRecipeReserveInfo::setRecipeReserveInfo()
     * @param \StructType\RecipeReserveInfo[] $recipeReserveInfo
     */
    public function __construct(array $recipeReserveInfo = array())
    {
        $this
            ->setRecipeReserveInfo($recipeReserveInfo);
    }
    /**
     * Get RecipeReserveInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RecipeReserveInfo[]|null
     */
    public function getRecipeReserveInfo()
    {
        return isset($this->RecipeReserveInfo) ? $this->RecipeReserveInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRecipeReserveInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecipeReserveInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecipeReserveInfoForArrayConstraintsFromSetRecipeReserveInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfRecipeReserveInfoRecipeReserveInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfRecipeReserveInfoRecipeReserveInfoItem instanceof \StructType\RecipeReserveInfo) {
                $invalidValues[] = is_object($arrayOfRecipeReserveInfoRecipeReserveInfoItem) ? get_class($arrayOfRecipeReserveInfoRecipeReserveInfoItem) : sprintf('%s(%s)', gettype($arrayOfRecipeReserveInfoRecipeReserveInfoItem), var_export($arrayOfRecipeReserveInfoRecipeReserveInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RecipeReserveInfo property can only contain items of type \StructType\RecipeReserveInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RecipeReserveInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RecipeReserveInfo[] $recipeReserveInfo
     * @return \ArrayType\ArrayOfRecipeReserveInfo
     */
    public function setRecipeReserveInfo(array $recipeReserveInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($recipeReserveInfoArrayErrorMessage = self::validateRecipeReserveInfoForArrayConstraintsFromSetRecipeReserveInfo($recipeReserveInfo))) {
            throw new \InvalidArgumentException($recipeReserveInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($recipeReserveInfo) || (is_array($recipeReserveInfo) && empty($recipeReserveInfo))) {
            unset($this->RecipeReserveInfo);
        } else {
            $this->RecipeReserveInfo = $recipeReserveInfo;
        }
        return $this;
    }
    /**
     * Add item to RecipeReserveInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\RecipeReserveInfo $item
     * @return \ArrayType\ArrayOfRecipeReserveInfo
     */
    public function addToRecipeReserveInfo(\StructType\RecipeReserveInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RecipeReserveInfo) {
            throw new \InvalidArgumentException(sprintf('The RecipeReserveInfo property can only contain items of type \StructType\RecipeReserveInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RecipeReserveInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RecipeReserveInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RecipeReserveInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RecipeReserveInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RecipeReserveInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RecipeReserveInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RecipeReserveInfo
     */
    public function getAttributeName()
    {
        return 'RecipeReserveInfo';
    }
}
