<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRecipeClient ArrayType
 * @subpackage Arrays
 */
class ArrayOfRecipeClient extends AbstractStructArrayBase
{
    /**
     * The RecipeClient
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RecipeClient[]
     */
    public $RecipeClient;
    /**
     * Constructor method for ArrayOfRecipeClient
     * @uses ArrayOfRecipeClient::setRecipeClient()
     * @param \StructType\RecipeClient[] $recipeClient
     */
    public function __construct(array $recipeClient = array())
    {
        $this
            ->setRecipeClient($recipeClient);
    }
    /**
     * Get RecipeClient value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RecipeClient[]|null
     */
    public function getRecipeClient()
    {
        return isset($this->RecipeClient) ? $this->RecipeClient : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRecipeClient method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecipeClient method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecipeClientForArrayConstraintsFromSetRecipeClient(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfRecipeClientRecipeClientItem) {
            // validation for constraint: itemType
            if (!$arrayOfRecipeClientRecipeClientItem instanceof \StructType\RecipeClient) {
                $invalidValues[] = is_object($arrayOfRecipeClientRecipeClientItem) ? get_class($arrayOfRecipeClientRecipeClientItem) : sprintf('%s(%s)', gettype($arrayOfRecipeClientRecipeClientItem), var_export($arrayOfRecipeClientRecipeClientItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RecipeClient property can only contain items of type \StructType\RecipeClient, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RecipeClient value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RecipeClient[] $recipeClient
     * @return \ArrayType\ArrayOfRecipeClient
     */
    public function setRecipeClient(array $recipeClient = array())
    {
        // validation for constraint: array
        if ('' !== ($recipeClientArrayErrorMessage = self::validateRecipeClientForArrayConstraintsFromSetRecipeClient($recipeClient))) {
            throw new \InvalidArgumentException($recipeClientArrayErrorMessage, __LINE__);
        }
        if (is_null($recipeClient) || (is_array($recipeClient) && empty($recipeClient))) {
            unset($this->RecipeClient);
        } else {
            $this->RecipeClient = $recipeClient;
        }
        return $this;
    }
    /**
     * Add item to RecipeClient value
     * @throws \InvalidArgumentException
     * @param \StructType\RecipeClient $item
     * @return \ArrayType\ArrayOfRecipeClient
     */
    public function addToRecipeClient(\StructType\RecipeClient $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RecipeClient) {
            throw new \InvalidArgumentException(sprintf('The RecipeClient property can only contain items of type \StructType\RecipeClient, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RecipeClient[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RecipeClient|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RecipeClient|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RecipeClient|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RecipeClient|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RecipeClient|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RecipeClient
     */
    public function getAttributeName()
    {
        return 'RecipeClient';
    }
}
