<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sorting StructType
 * @subpackage Structs
 */
class Sorting extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The DataField
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $DataField;
    /**
     * The SortOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $SortOrder;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SortingServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for Sorting
     * @uses Sorting::setDisplayName()
     * @uses Sorting::setDataField()
     * @uses Sorting::setSortOrder()
     * @uses Sorting::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $dataField
     * @param \StructType\Field $sortOrder
     * @param \StructType\SortingServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $dataField = null, \StructType\Field $sortOrder = null, \StructType\SortingServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setDataField($dataField)
            ->setSortOrder($sortOrder)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\Sorting
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get DataField value
     * @return \StructType\Field|null
     */
    public function getDataField()
    {
        return $this->DataField;
    }
    /**
     * Set DataField value
     * @param \StructType\Field $dataField
     * @return \StructType\Sorting
     */
    public function setDataField(\StructType\Field $dataField = null)
    {
        $this->DataField = $dataField;
        return $this;
    }
    /**
     * Get SortOrder value
     * @return \StructType\Field|null
     */
    public function getSortOrder()
    {
        return $this->SortOrder;
    }
    /**
     * Set SortOrder value
     * @param \StructType\Field $sortOrder
     * @return \StructType\Sorting
     */
    public function setSortOrder(\StructType\Field $sortOrder = null)
    {
        $this->SortOrder = $sortOrder;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\SortingServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\SortingServiceCommands $serviceCommands
     * @return \StructType\Sorting
     */
    public function setServiceCommands(\StructType\SortingServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
}
