<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Template StructType
 * @subpackage Structs
 */
class Template extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Name;
    /**
     * The IsDefault
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $IsDefault;
    /**
     * The IsShared
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $IsShared;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TemplateServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for Template
     * @uses Template::setDisplayName()
     * @uses Template::setName()
     * @uses Template::setIsDefault()
     * @uses Template::setIsShared()
     * @uses Template::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $name
     * @param \StructType\Field $isDefault
     * @param \StructType\Field $isShared
     * @param \StructType\TemplateServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $name = null, \StructType\Field $isDefault = null, \StructType\Field $isShared = null, \StructType\TemplateServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setName($name)
            ->setIsDefault($isDefault)
            ->setIsShared($isShared)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\Template
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get Name value
     * @return \StructType\Field|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \StructType\Field $name
     * @return \StructType\Template
     */
    public function setName(\StructType\Field $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get IsDefault value
     * @return \StructType\Field|null
     */
    public function getIsDefault()
    {
        return $this->IsDefault;
    }
    /**
     * Set IsDefault value
     * @param \StructType\Field $isDefault
     * @return \StructType\Template
     */
    public function setIsDefault(\StructType\Field $isDefault = null)
    {
        $this->IsDefault = $isDefault;
        return $this;
    }
    /**
     * Get IsShared value
     * @return \StructType\Field|null
     */
    public function getIsShared()
    {
        return $this->IsShared;
    }
    /**
     * Set IsShared value
     * @param \StructType\Field $isShared
     * @return \StructType\Template
     */
    public function setIsShared(\StructType\Field $isShared = null)
    {
        $this->IsShared = $isShared;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\TemplateServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\TemplateServiceCommands $serviceCommands
     * @return \StructType\Template
     */
    public function setServiceCommands(\StructType\TemplateServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
}
