<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Parameters StructType
 * @subpackage Structs
 */
class Parameters extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The DocumentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $DocumentType;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ReferenceNumber;
    /**
     * The FirstTimePrintedEmailed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $FirstTimePrintedEmailed;
    /**
     * The LineTypeDS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $LineTypeDS;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ParametersServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for Parameters
     * @uses Parameters::setDisplayName()
     * @uses Parameters::setDocumentType()
     * @uses Parameters::setReferenceNumber()
     * @uses Parameters::setFirstTimePrintedEmailed()
     * @uses Parameters::setLineTypeDS()
     * @uses Parameters::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $documentType
     * @param \StructType\Field $referenceNumber
     * @param \StructType\Field $firstTimePrintedEmailed
     * @param \StructType\Field $lineTypeDS
     * @param \StructType\ParametersServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $documentType = null, \StructType\Field $referenceNumber = null, \StructType\Field $firstTimePrintedEmailed = null, \StructType\Field $lineTypeDS = null, \StructType\ParametersServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setDocumentType($documentType)
            ->setReferenceNumber($referenceNumber)
            ->setFirstTimePrintedEmailed($firstTimePrintedEmailed)
            ->setLineTypeDS($lineTypeDS)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\Parameters
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get DocumentType value
     * @return \StructType\Field|null
     */
    public function getDocumentType()
    {
        return $this->DocumentType;
    }
    /**
     * Set DocumentType value
     * @param \StructType\Field $documentType
     * @return \StructType\Parameters
     */
    public function setDocumentType(\StructType\Field $documentType = null)
    {
        $this->DocumentType = $documentType;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return \StructType\Field|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param \StructType\Field $referenceNumber
     * @return \StructType\Parameters
     */
    public function setReferenceNumber(\StructType\Field $referenceNumber = null)
    {
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get FirstTimePrintedEmailed value
     * @return \StructType\Field|null
     */
    public function getFirstTimePrintedEmailed()
    {
        return $this->FirstTimePrintedEmailed;
    }
    /**
     * Set FirstTimePrintedEmailed value
     * @param \StructType\Field $firstTimePrintedEmailed
     * @return \StructType\Parameters
     */
    public function setFirstTimePrintedEmailed(\StructType\Field $firstTimePrintedEmailed = null)
    {
        $this->FirstTimePrintedEmailed = $firstTimePrintedEmailed;
        return $this;
    }
    /**
     * Get LineTypeDS value
     * @return \StructType\Field|null
     */
    public function getLineTypeDS()
    {
        return $this->LineTypeDS;
    }
    /**
     * Set LineTypeDS value
     * @param \StructType\Field $lineTypeDS
     * @return \StructType\Parameters
     */
    public function setLineTypeDS(\StructType\Field $lineTypeDS = null)
    {
        $this->LineTypeDS = $lineTypeDS;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\ParametersServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\ParametersServiceCommands $serviceCommands
     * @return \StructType\Parameters
     */
    public function setServiceCommands(\StructType\ParametersServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
}
