<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ElementDescriptor StructType
 * @subpackage Structs
 */
class ElementDescriptor extends AbstractStructBase
{
    /**
     * The FieldPriority
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FieldPriority;
    /**
     * The ButtonType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ButtonType;
    /**
     * The Visible
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Visible;
    /**
     * The IsTimeList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsTimeList;
    /**
     * The PreserveTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $PreserveTime;
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The IsDisabled
     * Meta information extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsDisabled;
    /**
     * The IsRequired
     * Meta information extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsRequired;
    /**
     * The ElementType
     * Meta information extracted from the WSDL
     * - default: String
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ElementType;
    /**
     * The LengthLimit
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $LengthLimit;
    /**
     * The InputMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InputMask;
    /**
     * The DisplayRules
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayRules;
    /**
     * The AllowedValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $AllowedValues;
    /**
     * The Container
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Container
     */
    public $Container;
    /**
     * The ActionIcon
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ActionIcon;
    /**
     * The LinkCommand
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LinkCommand;
    /**
     * The DependsOn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DependsOn;
    /**
     * The StateColumn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StateColumn;
    /**
     * Constructor method for ElementDescriptor
     * @uses ElementDescriptor::setFieldPriority()
     * @uses ElementDescriptor::setButtonType()
     * @uses ElementDescriptor::setVisible()
     * @uses ElementDescriptor::setIsTimeList()
     * @uses ElementDescriptor::setPreserveTime()
     * @uses ElementDescriptor::setDisplayName()
     * @uses ElementDescriptor::setIsDisabled()
     * @uses ElementDescriptor::setIsRequired()
     * @uses ElementDescriptor::setElementType()
     * @uses ElementDescriptor::setLengthLimit()
     * @uses ElementDescriptor::setInputMask()
     * @uses ElementDescriptor::setDisplayRules()
     * @uses ElementDescriptor::setAllowedValues()
     * @uses ElementDescriptor::setContainer()
     * @uses ElementDescriptor::setActionIcon()
     * @uses ElementDescriptor::setLinkCommand()
     * @uses ElementDescriptor::setDependsOn()
     * @uses ElementDescriptor::setStateColumn()
     * @param int $fieldPriority
     * @param string $buttonType
     * @param bool $visible
     * @param bool $isTimeList
     * @param bool $preserveTime
     * @param string $displayName
     * @param bool $isDisabled
     * @param bool $isRequired
     * @param string $elementType
     * @param int $lengthLimit
     * @param string $inputMask
     * @param string $displayRules
     * @param \ArrayType\ArrayOfString $allowedValues
     * @param \StructType\Container $container
     * @param string $actionIcon
     * @param string $linkCommand
     * @param string $dependsOn
     * @param string $stateColumn
     */
    public function __construct($fieldPriority = null, $buttonType = null, $visible = null, $isTimeList = null, $preserveTime = null, $displayName = null, $isDisabled = false, $isRequired = false, $elementType = 'String', $lengthLimit = 0, $inputMask = null, $displayRules = null, \ArrayType\ArrayOfString $allowedValues = null, \StructType\Container $container = null, $actionIcon = null, $linkCommand = null, $dependsOn = null, $stateColumn = null)
    {
        $this
            ->setFieldPriority($fieldPriority)
            ->setButtonType($buttonType)
            ->setVisible($visible)
            ->setIsTimeList($isTimeList)
            ->setPreserveTime($preserveTime)
            ->setDisplayName($displayName)
            ->setIsDisabled($isDisabled)
            ->setIsRequired($isRequired)
            ->setElementType($elementType)
            ->setLengthLimit($lengthLimit)
            ->setInputMask($inputMask)
            ->setDisplayRules($displayRules)
            ->setAllowedValues($allowedValues)
            ->setContainer($container)
            ->setActionIcon($actionIcon)
            ->setLinkCommand($linkCommand)
            ->setDependsOn($dependsOn)
            ->setStateColumn($stateColumn);
    }
    /**
     * Get FieldPriority value
     * @return int
     */
    public function getFieldPriority()
    {
        return $this->FieldPriority;
    }
    /**
     * Set FieldPriority value
     * @param int $fieldPriority
     * @return \StructType\ElementDescriptor
     */
    public function setFieldPriority($fieldPriority = null)
    {
        // validation for constraint: int
        if (!is_null($fieldPriority) && !(is_int($fieldPriority) || ctype_digit($fieldPriority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fieldPriority, true), gettype($fieldPriority)), __LINE__);
        }
        $this->FieldPriority = $fieldPriority;
        return $this;
    }
    /**
     * Get ButtonType value
     * @return string
     */
    public function getButtonType()
    {
        return $this->ButtonType;
    }
    /**
     * Set ButtonType value
     * @uses \EnumType\PXSpecialButtonType::valueIsValid()
     * @uses \EnumType\PXSpecialButtonType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $buttonType
     * @return \StructType\ElementDescriptor
     */
    public function setButtonType($buttonType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PXSpecialButtonType::valueIsValid($buttonType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PXSpecialButtonType', is_array($buttonType) ? implode(', ', $buttonType) : var_export($buttonType, true), implode(', ', \EnumType\PXSpecialButtonType::getValidValues())), __LINE__);
        }
        $this->ButtonType = $buttonType;
        return $this;
    }
    /**
     * Get Visible value
     * @return bool
     */
    public function getVisible()
    {
        return $this->Visible;
    }
    /**
     * Set Visible value
     * @param bool $visible
     * @return \StructType\ElementDescriptor
     */
    public function setVisible($visible = null)
    {
        // validation for constraint: boolean
        if (!is_null($visible) && !is_bool($visible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visible, true), gettype($visible)), __LINE__);
        }
        $this->Visible = $visible;
        return $this;
    }
    /**
     * Get IsTimeList value
     * @return bool
     */
    public function getIsTimeList()
    {
        return $this->IsTimeList;
    }
    /**
     * Set IsTimeList value
     * @param bool $isTimeList
     * @return \StructType\ElementDescriptor
     */
    public function setIsTimeList($isTimeList = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTimeList) && !is_bool($isTimeList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTimeList, true), gettype($isTimeList)), __LINE__);
        }
        $this->IsTimeList = $isTimeList;
        return $this;
    }
    /**
     * Get PreserveTime value
     * @return bool
     */
    public function getPreserveTime()
    {
        return $this->PreserveTime;
    }
    /**
     * Set PreserveTime value
     * @param bool $preserveTime
     * @return \StructType\ElementDescriptor
     */
    public function setPreserveTime($preserveTime = null)
    {
        // validation for constraint: boolean
        if (!is_null($preserveTime) && !is_bool($preserveTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preserveTime, true), gettype($preserveTime)), __LINE__);
        }
        $this->PreserveTime = $preserveTime;
        return $this;
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\ElementDescriptor
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get IsDisabled value
     * @return bool|null
     */
    public function getIsDisabled()
    {
        return $this->IsDisabled;
    }
    /**
     * Set IsDisabled value
     * @param bool $isDisabled
     * @return \StructType\ElementDescriptor
     */
    public function setIsDisabled($isDisabled = false)
    {
        // validation for constraint: boolean
        if (!is_null($isDisabled) && !is_bool($isDisabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDisabled, true), gettype($isDisabled)), __LINE__);
        }
        $this->IsDisabled = $isDisabled;
        return $this;
    }
    /**
     * Get IsRequired value
     * @return bool|null
     */
    public function getIsRequired()
    {
        return $this->IsRequired;
    }
    /**
     * Set IsRequired value
     * @param bool $isRequired
     * @return \StructType\ElementDescriptor
     */
    public function setIsRequired($isRequired = false)
    {
        // validation for constraint: boolean
        if (!is_null($isRequired) && !is_bool($isRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRequired, true), gettype($isRequired)), __LINE__);
        }
        $this->IsRequired = $isRequired;
        return $this;
    }
    /**
     * Get ElementType value
     * @return string|null
     */
    public function getElementType()
    {
        return $this->ElementType;
    }
    /**
     * Set ElementType value
     * @uses \EnumType\ElementTypes::valueIsValid()
     * @uses \EnumType\ElementTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $elementType
     * @return \StructType\ElementDescriptor
     */
    public function setElementType($elementType = 'String')
    {
        // validation for constraint: enumeration
        if (!\EnumType\ElementTypes::valueIsValid($elementType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ElementTypes', is_array($elementType) ? implode(', ', $elementType) : var_export($elementType, true), implode(', ', \EnumType\ElementTypes::getValidValues())), __LINE__);
        }
        $this->ElementType = $elementType;
        return $this;
    }
    /**
     * Get LengthLimit value
     * @return int|null
     */
    public function getLengthLimit()
    {
        return $this->LengthLimit;
    }
    /**
     * Set LengthLimit value
     * @param int $lengthLimit
     * @return \StructType\ElementDescriptor
     */
    public function setLengthLimit($lengthLimit = 0)
    {
        // validation for constraint: int
        if (!is_null($lengthLimit) && !(is_int($lengthLimit) || ctype_digit($lengthLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lengthLimit, true), gettype($lengthLimit)), __LINE__);
        }
        $this->LengthLimit = $lengthLimit;
        return $this;
    }
    /**
     * Get InputMask value
     * @return string|null
     */
    public function getInputMask()
    {
        return $this->InputMask;
    }
    /**
     * Set InputMask value
     * @param string $inputMask
     * @return \StructType\ElementDescriptor
     */
    public function setInputMask($inputMask = null)
    {
        // validation for constraint: string
        if (!is_null($inputMask) && !is_string($inputMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inputMask, true), gettype($inputMask)), __LINE__);
        }
        $this->InputMask = $inputMask;
        return $this;
    }
    /**
     * Get DisplayRules value
     * @return string|null
     */
    public function getDisplayRules()
    {
        return $this->DisplayRules;
    }
    /**
     * Set DisplayRules value
     * @param string $displayRules
     * @return \StructType\ElementDescriptor
     */
    public function setDisplayRules($displayRules = null)
    {
        // validation for constraint: string
        if (!is_null($displayRules) && !is_string($displayRules)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayRules, true), gettype($displayRules)), __LINE__);
        }
        $this->DisplayRules = $displayRules;
        return $this;
    }
    /**
     * Get AllowedValues value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getAllowedValues()
    {
        return $this->AllowedValues;
    }
    /**
     * Set AllowedValues value
     * @param \ArrayType\ArrayOfString $allowedValues
     * @return \StructType\ElementDescriptor
     */
    public function setAllowedValues(\ArrayType\ArrayOfString $allowedValues = null)
    {
        $this->AllowedValues = $allowedValues;
        return $this;
    }
    /**
     * Get Container value
     * @return \StructType\Container|null
     */
    public function getContainer()
    {
        return $this->Container;
    }
    /**
     * Set Container value
     * @param \StructType\Container $container
     * @return \StructType\ElementDescriptor
     */
    public function setContainer(\StructType\Container $container = null)
    {
        $this->Container = $container;
        return $this;
    }
    /**
     * Get ActionIcon value
     * @return string|null
     */
    public function getActionIcon()
    {
        return $this->ActionIcon;
    }
    /**
     * Set ActionIcon value
     * @param string $actionIcon
     * @return \StructType\ElementDescriptor
     */
    public function setActionIcon($actionIcon = null)
    {
        // validation for constraint: string
        if (!is_null($actionIcon) && !is_string($actionIcon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionIcon, true), gettype($actionIcon)), __LINE__);
        }
        $this->ActionIcon = $actionIcon;
        return $this;
    }
    /**
     * Get LinkCommand value
     * @return string|null
     */
    public function getLinkCommand()
    {
        return $this->LinkCommand;
    }
    /**
     * Set LinkCommand value
     * @param string $linkCommand
     * @return \StructType\ElementDescriptor
     */
    public function setLinkCommand($linkCommand = null)
    {
        // validation for constraint: string
        if (!is_null($linkCommand) && !is_string($linkCommand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkCommand, true), gettype($linkCommand)), __LINE__);
        }
        $this->LinkCommand = $linkCommand;
        return $this;
    }
    /**
     * Get DependsOn value
     * @return string|null
     */
    public function getDependsOn()
    {
        return $this->DependsOn;
    }
    /**
     * Set DependsOn value
     * @param string $dependsOn
     * @return \StructType\ElementDescriptor
     */
    public function setDependsOn($dependsOn = null)
    {
        // validation for constraint: string
        if (!is_null($dependsOn) && !is_string($dependsOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dependsOn, true), gettype($dependsOn)), __LINE__);
        }
        $this->DependsOn = $dependsOn;
        return $this;
    }
    /**
     * Get StateColumn value
     * @return string|null
     */
    public function getStateColumn()
    {
        return $this->StateColumn;
    }
    /**
     * Set StateColumn value
     * @param string $stateColumn
     * @return \StructType\ElementDescriptor
     */
    public function setStateColumn($stateColumn = null)
    {
        // validation for constraint: string
        if (!is_null($stateColumn) && !is_string($stateColumn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateColumn, true), gettype($stateColumn)), __LINE__);
        }
        $this->StateColumn = $stateColumn;
        return $this;
    }
}
