<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for FilterCondition EnumType
 * @subpackage Enumerations
 */
class FilterCondition extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Equals'
     * @return string 'Equals'
     */
    const VALUE_EQUALS = 'Equals';
    /**
     * Constant for value 'NotEqual'
     * @return string 'NotEqual'
     */
    const VALUE_NOT_EQUAL = 'NotEqual';
    /**
     * Constant for value 'Greater'
     * @return string 'Greater'
     */
    const VALUE_GREATER = 'Greater';
    /**
     * Constant for value 'GreaterOrEqual'
     * @return string 'GreaterOrEqual'
     */
    const VALUE_GREATER_OR_EQUAL = 'GreaterOrEqual';
    /**
     * Constant for value 'Less'
     * @return string 'Less'
     */
    const VALUE_LESS = 'Less';
    /**
     * Constant for value 'LessOrEqual'
     * @return string 'LessOrEqual'
     */
    const VALUE_LESS_OR_EQUAL = 'LessOrEqual';
    /**
     * Constant for value 'Contain'
     * @return string 'Contain'
     */
    const VALUE_CONTAIN = 'Contain';
    /**
     * Constant for value 'StartsWith'
     * @return string 'StartsWith'
     */
    const VALUE_STARTS_WITH = 'StartsWith';
    /**
     * Constant for value 'EndsWith'
     * @return string 'EndsWith'
     */
    const VALUE_ENDS_WITH = 'EndsWith';
    /**
     * Constant for value 'NotContain'
     * @return string 'NotContain'
     */
    const VALUE_NOT_CONTAIN = 'NotContain';
    /**
     * Constant for value 'Between'
     * @return string 'Between'
     */
    const VALUE_BETWEEN = 'Between';
    /**
     * Constant for value 'IsNull'
     * @return string 'IsNull'
     */
    const VALUE_IS_NULL = 'IsNull';
    /**
     * Constant for value 'IsNotNull'
     * @return string 'IsNotNull'
     */
    const VALUE_IS_NOT_NULL = 'IsNotNull';
    /**
     * Return allowed values
     * @uses self::VALUE_EQUALS
     * @uses self::VALUE_NOT_EQUAL
     * @uses self::VALUE_GREATER
     * @uses self::VALUE_GREATER_OR_EQUAL
     * @uses self::VALUE_LESS
     * @uses self::VALUE_LESS_OR_EQUAL
     * @uses self::VALUE_CONTAIN
     * @uses self::VALUE_STARTS_WITH
     * @uses self::VALUE_ENDS_WITH
     * @uses self::VALUE_NOT_CONTAIN
     * @uses self::VALUE_BETWEEN
     * @uses self::VALUE_IS_NULL
     * @uses self::VALUE_IS_NOT_NULL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EQUALS,
            self::VALUE_NOT_EQUAL,
            self::VALUE_GREATER,
            self::VALUE_GREATER_OR_EQUAL,
            self::VALUE_LESS,
            self::VALUE_LESS_OR_EQUAL,
            self::VALUE_CONTAIN,
            self::VALUE_STARTS_WITH,
            self::VALUE_ENDS_WITH,
            self::VALUE_NOT_CONTAIN,
            self::VALUE_BETWEEN,
            self::VALUE_IS_NULL,
            self::VALUE_IS_NOT_NULL,
        );
    }
}
