<?php
/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'Clear' => '\\StructType\\Clear',
            'ClearResponse' => '\\StructType\\ClearResponse',
            'GetProcessStatus' => '\\StructType\\GetProcessStatus',
            'GetProcessStatusResponse' => '\\StructType\\GetProcessStatusResponse',
            'ProcessResult' => '\\StructType\\ProcessResult',
            'GetScenario' => '\\StructType\\GetScenario',
            'GetScenarioResponse' => '\\StructType\\GetScenarioResponse',
            'ArrayOfCommand' => '\\ArrayType\\ArrayOfCommand',
            'Command' => '\\StructType\\Command',
            'ElementDescriptor' => '\\StructType\\ElementDescriptor',
            'ArrayOfString' => '\\ArrayType\\ArrayOfString',
            'Container' => '\\StructType\\Container',
            'ArrayOfField' => '\\ArrayType\\ArrayOfField',
            'Field' => '\\StructType\\Field',
            'Attachment' => '\\StructType\\Attachment',
            'Value' => '\\StructType\\Value',
            'ArrayOfContainer' => '\\ArrayType\\ArrayOfContainer',
            'EveryValue' => '\\StructType\\EveryValue',
            'Answer' => '\\StructType\\Answer',
            'RowNumber' => '\\StructType\\RowNumber',
            'DeleteRow' => '\\StructType\\DeleteRow',
            'NewRow' => '\\StructType\\NewRow',
            'Parameter' => '\\StructType\\Parameter',
            'Key' => '\\StructType\\Key',
            'Action' => '\\StructType\\Action',
            'GetSchema' => '\\StructType\\GetSchema',
            'GetSchemaResponse' => '\\StructType\\GetSchemaResponse',
            'Content' => '\\StructType\\Content',
            'SetSchema' => '\\StructType\\SetSchema',
            'SetSchemaResponse' => '\\StructType\\SetSchemaResponse',
            'Export' => '\\StructType\\Export',
            'ArrayOfFilter' => '\\ArrayType\\ArrayOfFilter',
            'Filter' => '\\StructType\\Filter',
            'ArrayOfArrayOfString' => '\\ArrayType\\ArrayOfArrayOfString',
            'ExportResponse' => '\\StructType\\ExportResponse',
            'Import' => '\\StructType\\Import',
            'ImportResult' => '\\StructType\\ImportResult',
            'ArrayOfValue' => '\\ArrayType\\ArrayOfValue',
            'ArrayOfImportResult' => '\\ArrayType\\ArrayOfImportResult',
            'ImportResponse' => '\\StructType\\ImportResponse',
            'Submit' => '\\StructType\\Submit',
            'ArrayOfContent' => '\\ArrayType\\ArrayOfContent',
            'SubmitResponse' => '\\StructType\\SubmitResponse',
            'Login' => '\\StructType\\Login',
            'LoginResult' => '\\StructType\\LoginResult',
            'LoginResponse' => '\\StructType\\LoginResponse',
            'Logout' => '\\StructType\\Logout',
            'LogoutResponse' => '\\StructType\\LogoutResponse',
            'SetBusinessDate' => '\\StructType\\SetBusinessDate',
            'SetBusinessDateResponse' => '\\StructType\\SetBusinessDateResponse',
            'SetLocaleName' => '\\StructType\\SetLocaleName',
            'SetLocaleNameResponse' => '\\StructType\\SetLocaleNameResponse',
            'SetSchemaMode' => '\\StructType\\SetSchemaMode',
            'SetSchemaModeResponse' => '\\StructType\\SetSchemaModeResponse',
            'Actions' => '\\StructType\\Actions',
            'ParametersServiceCommands' => '\\StructType\\ParametersServiceCommands',
            'Parameters' => '\\StructType\\Parameters',
            'CommonSettingsServiceCommands' => '\\StructType\\CommonSettingsServiceCommands',
            'CommonSettings' => '\\StructType\\CommonSettings',
            'MailSettingsServiceCommands' => '\\StructType\\MailSettingsServiceCommands',
            'MailSettings' => '\\StructType\\MailSettings',
            'SortingServiceCommands' => '\\StructType\\SortingServiceCommands',
            'Sorting' => '\\StructType\\Sorting',
            'FiltersServiceCommands' => '\\StructType\\FiltersServiceCommands',
            'Filters' => '\\StructType\\Filters',
            'ReportResultsServiceCommands' => '\\StructType\\ReportResultsServiceCommands',
            'ReportResults' => '\\StructType\\ReportResults',
            'TemplateServiceCommands' => '\\StructType\\TemplateServiceCommands',
            'Template' => '\\StructType\\Template',
        );
    }
}
