<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
$get->setSoapHeaderMsgType(new \StructType\MsgType());
$get->setSoapHeaderTimestamp(new \StructType\Timestamp());
$get->setSoapHeaderMsgId(new \StructType\MsgId());
$get->setSoapHeaderExecId(new \StructType\ExecId());
$get->setSoapHeaderPid(new \StructType\Pid());
$get->setSoapHeaderDestination(new \StructType\Destination());
$get->setSoapHeaderOperation(new \StructType\Operation());
$get->setSoapHeaderWsIpv6(new \StructType\WsIpv6());
$get->setSoapHeaderWsIp(new \StructType\WsIp());
$get->setSoapHeaderWsId(new \StructType\WsId());
$get->setSoapHeaderUserId(new \StructType\UserId());
$get->setSoapHeaderSender(new \StructType\Sender());
$get->setSoapHeaderOriginator(new \StructType\Originator());
$get->setSoapHeaderSubsystem(new \StructType\Subsystem());
$get->setSoapHeaderSystem(new \StructType\System());
$get->setSoapHeaderEntity(new \StructType\Entity());
$get->setSoapHeaderLang(new \StructType\Lang());
$get->setSoapHeaderCountry(new \StructType\Country());
/**
 * Sample call for GetDMPE operation/method
 */
if ($get->GetDMPE($tipo, $parametro) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
