<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the MsgType SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\MsgType $msgType
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderMsgType(\StructType\MsgType $msgType, $nameSpace = 'urn:GAMPEWS', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'msgType', $msgType, $mustUnderstand, $actor);
    }
    /**
     * Sets the Timestamp SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Timestamp $timestamp
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderTimestamp(\StructType\Timestamp $timestamp, $nameSpace = 'urn:GAMPEWS', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'timestamp', $timestamp, $mustUnderstand, $actor);
    }
    /**
     * Sets the MsgId SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\MsgId $msgId
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderMsgId(\StructType\MsgId $msgId, $nameSpace = 'urn:GAMPEWS', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'msgId', $msgId, $mustUnderstand, $actor);
    }
    /**
     * Sets the ExecId SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ExecId $execId
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderExecId(\StructType\ExecId $execId, $nameSpace = 'urn:GAMPEWS', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'execId', $execId, $mustUnderstand, $actor);
    }
    /**
     * Sets the Pid SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Pid $pid
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderPid(\StructType\Pid $pid, $nameSpace = 'urn:GAMPEWS', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'pid', $pid, $mustUnderstand, $actor);
    }
    /**
     * Sets the Destination SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Destination $destination
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderDestination(\StructType\Destination $destination, $nameSpace = 'urn:GAMPEWS', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'destination', $destination, $mustUnderstand, $actor);
    }
    /**
     * Sets the Operation SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Operation $operation
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderOperation(\StructType\Operation $operation, $nameSpace = 'urn:GAMPEWS', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'operation', $operation, $mustUnderstand, $actor);
    }
    /**
     * Sets the WsIpv6 SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\WsIpv6 $wsIpv6
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderWsIpv6(\StructType\WsIpv6 $wsIpv6, $nameSpace = 'urn:GAMPEWS', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'wsIpv6', $wsIpv6, $mustUnderstand, $actor);
    }
    /**
     * Sets the WsIp SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\WsIp $wsIp
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderWsIp(\StructType\WsIp $wsIp, $nameSpace = 'urn:GAMPEWS', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'wsIp', $wsIp, $mustUnderstand, $actor);
    }
    /**
     * Sets the WsId SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\WsId $wsId
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderWsId(\StructType\WsId $wsId, $nameSpace = 'urn:GAMPEWS', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'wsId', $wsId, $mustUnderstand, $actor);
    }
    /**
     * Sets the UserId SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\UserId $userId
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderUserId(\StructType\UserId $userId, $nameSpace = 'urn:GAMPEWS', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'userId', $userId, $mustUnderstand, $actor);
    }
    /**
     * Sets the Sender SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Sender $sender
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSender(\StructType\Sender $sender, $nameSpace = 'urn:GAMPEWS', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'sender', $sender, $mustUnderstand, $actor);
    }
    /**
     * Sets the Originator SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Originator $originator
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderOriginator(\StructType\Originator $originator, $nameSpace = 'urn:GAMPEWS', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'originator', $originator, $mustUnderstand, $actor);
    }
    /**
     * Sets the Subsystem SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Subsystem $subsystem
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSubsystem(\StructType\Subsystem $subsystem, $nameSpace = 'urn:GAMPEWS', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'subsystem', $subsystem, $mustUnderstand, $actor);
    }
    /**
     * Sets the System SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\System $system
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSystem(\StructType\System $system, $nameSpace = 'urn:GAMPEWS', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'system', $system, $mustUnderstand, $actor);
    }
    /**
     * Sets the Entity SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Entity $entity
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderEntity(\StructType\Entity $entity, $nameSpace = 'urn:GAMPEWS', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'entity', $entity, $mustUnderstand, $actor);
    }
    /**
     * Sets the Lang SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Lang $lang
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderLang(\StructType\Lang $lang, $nameSpace = 'urn:GAMPEWS', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'lang', $lang, $mustUnderstand, $actor);
    }
    /**
     * Sets the Country SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Country $country
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderCountry(\StructType\Country $country, $nameSpace = 'urn:GAMPEWS', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'country', $country, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GetDMPE
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: msgType, timestamp, msgId, execId, pid, destination, operation, wsIpv6, wsIp, wsId, userId, sender, originator, subsystem, system, entity, lang, country
     * - SOAPHeaderNamespaces: urn:GAMPEWS, urn:GAMPEWS, urn:GAMPEWS, urn:GAMPEWS, urn:GAMPEWS, urn:GAMPEWS, urn:GAMPEWS, urn:GAMPEWS, urn:GAMPEWS, urn:GAMPEWS, urn:GAMPEWS, urn:GAMPEWS, urn:GAMPEWS, urn:GAMPEWS, urn:GAMPEWS, urn:GAMPEWS, urn:GAMPEWS, urn:GAMPEWS
     * - SOAPHeaderTypes: \StructType\MsgType, \StructType\Timestamp, \StructType\MsgId, \StructType\ExecId, \StructType\Pid, \StructType\Destination, \StructType\Operation, \StructType\WsIpv6, \StructType\WsIp, \StructType\WsId, \StructType\UserId, \StructType\Sender, \StructType\Originator, \StructType\Subsystem, \StructType\System, \StructType\Entity, \StructType\Lang, \StructType\Country
     * - SOAPHeaders: required, required, required, required, required, required, required, required, required, required, required, required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $tipo
     * @param string $parametro
     * @return \StructType\ArrayOfStringsResponse|bool
     */
    public function GetDMPE($tipo, $parametro)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDMPE($tipo, $parametro));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ArrayOfStringsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
