<?php
/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'country' => '\\StructType\\Country',
            'lang' => '\\StructType\\Lang',
            'entity' => '\\StructType\\Entity',
            'system' => '\\StructType\\System',
            'subsystem' => '\\StructType\\Subsystem',
            'originator' => '\\StructType\\Originator',
            'sender' => '\\StructType\\Sender',
            'userId' => '\\StructType\\UserId',
            'wsId' => '\\StructType\\WsId',
            'wsIp' => '\\StructType\\WsIp',
            'wsIpv6' => '\\StructType\\WsIpv6',
            'operation' => '\\StructType\\Operation',
            'destination' => '\\StructType\\Destination',
            'pid' => '\\StructType\\Pid',
            'execId' => '\\StructType\\ExecId',
            'msgId' => '\\StructType\\MsgId',
            'timestamp' => '\\StructType\\Timestamp',
            'msgType' => '\\StructType\\MsgType',
            'characteristicType' => '\\StructType\\CharacteristicType',
            'describeByListType' => '\\StructType\\DescribeByListType',
            'productType' => '\\StructType\\ProductType',
            'productArrayType' => '\\ArrayType\\ProductArrayType',
            'ArrayOfStringsResponse' => '\\StructType\\ArrayOfStringsResponse',
        );
    }
}
