<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for describeByListType StructType
 * @subpackage Structs
 */
class DescribeByListType extends AbstractStructBase
{
    /**
     * The Characteristic
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CharacteristicType[]
     */
    public $Characteristic;
    /**
     * Constructor method for describeByListType
     * @uses DescribeByListType::setCharacteristic()
     * @param \StructType\CharacteristicType[] $characteristic
     */
    public function __construct(array $characteristic = array())
    {
        $this
            ->setCharacteristic($characteristic);
    }
    /**
     * Get Characteristic value
     * @return \StructType\CharacteristicType[]|null
     */
    public function getCharacteristic()
    {
        return $this->Characteristic;
    }
    /**
     * This method is responsible for validating the values passed to the setCharacteristic method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCharacteristic method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCharacteristicForArrayConstraintsFromSetCharacteristic(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $describeByListTypeCharacteristicItem) {
            // validation for constraint: itemType
            if (!$describeByListTypeCharacteristicItem instanceof \StructType\CharacteristicType) {
                $invalidValues[] = is_object($describeByListTypeCharacteristicItem) ? get_class($describeByListTypeCharacteristicItem) : sprintf('%s(%s)', gettype($describeByListTypeCharacteristicItem), var_export($describeByListTypeCharacteristicItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Characteristic property can only contain items of type \StructType\CharacteristicType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Characteristic value
     * @throws \InvalidArgumentException
     * @param \StructType\CharacteristicType[] $characteristic
     * @return \StructType\DescribeByListType
     */
    public function setCharacteristic(array $characteristic = array())
    {
        // validation for constraint: array
        if ('' !== ($characteristicArrayErrorMessage = self::validateCharacteristicForArrayConstraintsFromSetCharacteristic($characteristic))) {
            throw new \InvalidArgumentException($characteristicArrayErrorMessage, __LINE__);
        }
        $this->Characteristic = $characteristic;
        return $this;
    }
    /**
     * Add item to Characteristic value
     * @throws \InvalidArgumentException
     * @param \StructType\CharacteristicType $item
     * @return \StructType\DescribeByListType
     */
    public function addToCharacteristic(\StructType\CharacteristicType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CharacteristicType) {
            throw new \InvalidArgumentException(sprintf('The Characteristic property can only contain items of type \StructType\CharacteristicType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Characteristic[] = $item;
        return $this;
    }
}
