<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://payments.ebizcharge.com/ebizsoap/v2/wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://payments.ebizcharge.com/ebizsoap/v2/wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for BANKCARDSALE ServiceType
 */
$bANKCARDSALE = new \ServiceType\BANKCARDSALE($options);
/**
 * Sample call for BANKCARD_SALE operation/method
 */
if ($bANKCARDSALE->BANKCARD_SALE(new \StructType\BANKCARD_SALE()) !== false) {
    print_r($bANKCARDSALE->getResult());
} else {
    print_r($bANKCARDSALE->getLastError());
}
/**
 * Samples for BANKCARDCREDITORREFUND ServiceType
 */
$bANKCARDCREDITORREFUND = new \ServiceType\BANKCARDCREDITORREFUND($options);
/**
 * Sample call for BANKCARD_CREDIT_OR_REFUND operation/method
 */
if ($bANKCARDCREDITORREFUND->BANKCARD_CREDIT_OR_REFUND(new \StructType\BANKCARD_CREDIT_OR_REFUND()) !== false) {
    print_r($bANKCARDCREDITORREFUND->getResult());
} else {
    print_r($bANKCARDCREDITORREFUND->getLastError());
}
/**
 * Samples for BANKCARDAUTHONLY ServiceType
 */
$bANKCARDAUTHONLY = new \ServiceType\BANKCARDAUTHONLY($options);
/**
 * Sample call for BANKCARD_AUTHONLY operation/method
 */
if ($bANKCARDAUTHONLY->BANKCARD_AUTHONLY(new \StructType\BANKCARD_AUTHONLY()) !== false) {
    print_r($bANKCARDAUTHONLY->getResult());
} else {
    print_r($bANKCARDAUTHONLY->getLastError());
}
/**
 * Samples for BANKCARDAUTHONLYL ServiceType
 */
$bANKCARDAUTHONLYL = new \ServiceType\BANKCARDAUTHONLYL($options);
/**
 * Sample call for BANKCARD_AUTHONLYL3 operation/method
 */
if ($bANKCARDAUTHONLYL->BANKCARD_AUTHONLYL3(new \StructType\BANKCARD_AUTHONLYL3()) !== false) {
    print_r($bANKCARDAUTHONLYL->getResult());
} else {
    print_r($bANKCARDAUTHONLYL->getLastError());
}
/**
 * Samples for BANKCARDCREDIT ServiceType
 */
$bANKCARDCREDIT = new \ServiceType\BANKCARDCREDIT($options);
/**
 * Sample call for BANKCARD_CREDIT operation/method
 */
if ($bANKCARDCREDIT->BANKCARD_CREDIT(new \StructType\BANKCARD_CREDIT()) !== false) {
    print_r($bANKCARDCREDIT->getResult());
} else {
    print_r($bANKCARDCREDIT->getLastError());
}
/**
 * Samples for BANKCARDVOID ServiceType
 */
$bANKCARDVOID = new \ServiceType\BANKCARDVOID($options);
/**
 * Sample call for BANKCARD_VOID operation/method
 */
if ($bANKCARDVOID->BANKCARD_VOID(new \StructType\BANKCARD_VOID()) !== false) {
    print_r($bANKCARDVOID->getResult());
} else {
    print_r($bANKCARDVOID->getLastError());
}
/**
 * Samples for BANKCARDPRIORAUTHSALE ServiceType
 */
$bANKCARDPRIORAUTHSALE = new \ServiceType\BANKCARDPRIORAUTHSALE($options);
/**
 * Sample call for BANKCARD_PRIOR_AUTH_SALE operation/method
 */
if ($bANKCARDPRIORAUTHSALE->BANKCARD_PRIOR_AUTH_SALE(new \StructType\BANKCARD_PRIOR_AUTH_SALE()) !== false) {
    print_r($bANKCARDPRIORAUTHSALE->getResult());
} else {
    print_r($bANKCARDPRIORAUTHSALE->getLastError());
}
/**
 * Samples for BANKCARDPHONEAUTHPOST ServiceType
 */
$bANKCARDPHONEAUTHPOST = new \ServiceType\BANKCARDPHONEAUTHPOST($options);
/**
 * Sample call for BANKCARD_PHONE_AUTH_POST operation/method
 */
if ($bANKCARDPHONEAUTHPOST->BANKCARD_PHONE_AUTH_POST(new \StructType\BANKCARD_PHONE_AUTH_POST()) !== false) {
    print_r($bANKCARDPHONEAUTHPOST->getResult());
} else {
    print_r($bANKCARDPHONEAUTHPOST->getLastError());
}
/**
 * Samples for BANKCHECKSALE ServiceType
 */
$bANKCHECKSALE = new \ServiceType\BANKCHECKSALE($options);
/**
 * Sample call for BANKCHECK_SALE operation/method
 */
if ($bANKCHECKSALE->BANKCHECK_SALE(new \StructType\BANKCHECK_SALE()) !== false) {
    print_r($bANKCHECKSALE->getResult());
} else {
    print_r($bANKCHECKSALE->getLastError());
}
/**
 * Samples for BANKCHECKCREDIT ServiceType
 */
$bANKCHECKCREDIT = new \ServiceType\BANKCHECKCREDIT($options);
/**
 * Sample call for BANKCHECK_CREDIT operation/method
 */
if ($bANKCHECKCREDIT->BANKCHECK_CREDIT(new \StructType\BANKCHECK_CREDIT()) !== false) {
    print_r($bANKCHECKCREDIT->getResult());
} else {
    print_r($bANKCHECKCREDIT->getLastError());
}
/**
 * Samples for BANKCARDSENDBATCH ServiceType
 */
$bANKCARDSENDBATCH = new \ServiceType\BANKCARDSENDBATCH($options);
/**
 * Sample call for BANKCARD_SEND_BATCH operation/method
 */
if ($bANKCARDSENDBATCH->BANKCARD_SEND_BATCH(new \StructType\BANKCARD_SEND_BATCH()) !== false) {
    print_r($bANKCARDSENDBATCH->getResult());
} else {
    print_r($bANKCARDSENDBATCH->getLastError());
}
/**
 * Samples for BANKCARDRUNBATCH ServiceType
 */
$bANKCARDRUNBATCH = new \ServiceType\BANKCARDRUNBATCH($options);
/**
 * Sample call for BANKCARD_RUN_BATCH operation/method
 */
if ($bANKCARDRUNBATCH->BANKCARD_RUN_BATCH(new \StructType\BANKCARD_RUN_BATCH()) !== false) {
    print_r($bANKCARDRUNBATCH->getResult());
} else {
    print_r($bANKCARDRUNBATCH->getLastError());
}
/**
 * Samples for BANKCARDGETBATCHSTATUS ServiceType
 */
$bANKCARDGETBATCHSTATUS = new \ServiceType\BANKCARDGETBATCHSTATUS($options);
/**
 * Sample call for BANKCARD_GET_BATCH_STATUS operation/method
 */
if ($bANKCARDGETBATCHSTATUS->BANKCARD_GET_BATCH_STATUS(new \StructType\BANKCARD_GET_BATCH_STATUS()) !== false) {
    print_r($bANKCARDGETBATCHSTATUS->getResult());
} else {
    print_r($bANKCARDGETBATCHSTATUS->getLastError());
}
/**
 * Samples for VERIFYBANKCARDSERVICE ServiceType
 */
$vERIFYBANKCARDSERVICE = new \ServiceType\VERIFYBANKCARDSERVICE($options);
/**
 * Sample call for VERIFY_BANKCARD_SERVICE operation/method
 */
if ($vERIFYBANKCARDSERVICE->VERIFY_BANKCARD_SERVICE(new \StructType\VERIFY_BANKCARD_SERVICE()) !== false) {
    print_r($vERIFYBANKCARDSERVICE->getResult());
} else {
    print_r($vERIFYBANKCARDSERVICE->getLastError());
}
/**
 * Samples for BANKCARDVERIFYCUSTOMERPAYMENTMETHOD ServiceType
 */
$bANKCARDVERIFYCUSTOMERPAYMENTMETHOD = new \ServiceType\BANKCARDVERIFYCUSTOMERPAYMENTMETHOD($options);
/**
 * Sample call for BANKCARD_VERIFY_CUSTOMER_PAYMENT_METHOD operation/method
 */
if ($bANKCARDVERIFYCUSTOMERPAYMENTMETHOD->BANKCARD_VERIFY_CUSTOMER_PAYMENT_METHOD(new \StructType\BANKCARD_VERIFY_CUSTOMER_PAYMENT_METHOD()) !== false) {
    print_r($bANKCARDVERIFYCUSTOMERPAYMENTMETHOD->getResult());
} else {
    print_r($bANKCARDVERIFYCUSTOMERPAYMENTMETHOD->getLastError());
}
/**
 * Samples for BANKCARDADDCUSTOMER ServiceType
 */
$bANKCARDADDCUSTOMER = new \ServiceType\BANKCARDADDCUSTOMER($options);
/**
 * Sample call for BANKCARD_ADD_CUSTOMER operation/method
 */
if ($bANKCARDADDCUSTOMER->BANKCARD_ADD_CUSTOMER(new \StructType\BANKCARD_ADD_CUSTOMER()) !== false) {
    print_r($bANKCARDADDCUSTOMER->getResult());
} else {
    print_r($bANKCARDADDCUSTOMER->getLastError());
}
/**
 * Samples for BANKCARDGETCUSTOMER ServiceType
 */
$bANKCARDGETCUSTOMER = new \ServiceType\BANKCARDGETCUSTOMER($options);
/**
 * Sample call for BANKCARD_GET_CUSTOMER operation/method
 */
if ($bANKCARDGETCUSTOMER->BANKCARD_GET_CUSTOMER(new \StructType\BANKCARD_GET_CUSTOMER()) !== false) {
    print_r($bANKCARDGETCUSTOMER->getResult());
} else {
    print_r($bANKCARDGETCUSTOMER->getLastError());
}
/**
 * Samples for BANKCARDDELCUSTOMER ServiceType
 */
$bANKCARDDELCUSTOMER = new \ServiceType\BANKCARDDELCUSTOMER($options);
/**
 * Sample call for BANKCARD_DEL_CUSTOMER operation/method
 */
if ($bANKCARDDELCUSTOMER->BANKCARD_DEL_CUSTOMER(new \StructType\BANKCARD_DEL_CUSTOMER()) !== false) {
    print_r($bANKCARDDELCUSTOMER->getResult());
} else {
    print_r($bANKCARDDELCUSTOMER->getLastError());
}
/**
 * Samples for BANKCARDADDCUSTOMERPAYMENTMETHOD ServiceType
 */
$bANKCARDADDCUSTOMERPAYMENTMETHOD = new \ServiceType\BANKCARDADDCUSTOMERPAYMENTMETHOD($options);
/**
 * Sample call for BANKCARD_ADD_CUSTOMER_PAYMENT_METHOD operation/method
 */
if ($bANKCARDADDCUSTOMERPAYMENTMETHOD->BANKCARD_ADD_CUSTOMER_PAYMENT_METHOD(new \StructType\BANKCARD_ADD_CUSTOMER_PAYMENT_METHOD()) !== false) {
    print_r($bANKCARDADDCUSTOMERPAYMENTMETHOD->getResult());
} else {
    print_r($bANKCARDADDCUSTOMERPAYMENTMETHOD->getLastError());
}
/**
 * Samples for BANKCARDDELCUSTOMERPAYMENTMETHOD ServiceType
 */
$bANKCARDDELCUSTOMERPAYMENTMETHOD = new \ServiceType\BANKCARDDELCUSTOMERPAYMENTMETHOD($options);
/**
 * Sample call for BANKCARD_DEL_CUSTOMER_PAYMENT_METHOD operation/method
 */
if ($bANKCARDDELCUSTOMERPAYMENTMETHOD->BANKCARD_DEL_CUSTOMER_PAYMENT_METHOD(new \StructType\BANKCARD_DEL_CUSTOMER_PAYMENT_METHOD()) !== false) {
    print_r($bANKCARDDELCUSTOMERPAYMENTMETHOD->getResult());
} else {
    print_r($bANKCARDDELCUSTOMERPAYMENTMETHOD->getLastError());
}
/**
 * Samples for BANKCARDCUSTOMERSALE ServiceType
 */
$bANKCARDCUSTOMERSALE = new \ServiceType\BANKCARDCUSTOMERSALE($options);
/**
 * Sample call for BANKCARD_CUSTOMER_SALE operation/method
 */
if ($bANKCARDCUSTOMERSALE->BANKCARD_CUSTOMER_SALE(new \StructType\BANKCARD_CUSTOMER_SALE()) !== false) {
    print_r($bANKCARDCUSTOMERSALE->getResult());
} else {
    print_r($bANKCARDCUSTOMERSALE->getLastError());
}
/**
 * Samples for BANKCARDCUSTOMERAUTHONLY ServiceType
 */
$bANKCARDCUSTOMERAUTHONLY = new \ServiceType\BANKCARDCUSTOMERAUTHONLY($options);
/**
 * Sample call for BANKCARD_CUSTOMER_AUTHONLY operation/method
 */
if ($bANKCARDCUSTOMERAUTHONLY->BANKCARD_CUSTOMER_AUTHONLY(new \StructType\BANKCARD_CUSTOMER_AUTHONLY()) !== false) {
    print_r($bANKCARDCUSTOMERAUTHONLY->getResult());
} else {
    print_r($bANKCARDCUSTOMERAUTHONLY->getLastError());
}
/**
 * Samples for BANKCARDCUSTOMERAUTHONLYL ServiceType
 */
$bANKCARDCUSTOMERAUTHONLYL = new \ServiceType\BANKCARDCUSTOMERAUTHONLYL($options);
/**
 * Sample call for BANKCARD_CUSTOMER_AUTHONLYL3 operation/method
 */
if ($bANKCARDCUSTOMERAUTHONLYL->BANKCARD_CUSTOMER_AUTHONLYL3(new \StructType\BANKCARD_CUSTOMER_AUTHONLYL3()) !== false) {
    print_r($bANKCARDCUSTOMERAUTHONLYL->getResult());
} else {
    print_r($bANKCARDCUSTOMERAUTHONLYL->getLastError());
}
/**
 * Samples for BANKCARDCUSTOMERCREDITORREFUND ServiceType
 */
$bANKCARDCUSTOMERCREDITORREFUND = new \ServiceType\BANKCARDCUSTOMERCREDITORREFUND($options);
/**
 * Sample call for BANKCARD_CUSTOMER_CREDIT_OR_REFUND operation/method
 */
if ($bANKCARDCUSTOMERCREDITORREFUND->BANKCARD_CUSTOMER_CREDIT_OR_REFUND(new \StructType\BANKCARD_CUSTOMER_CREDIT_OR_REFUND()) !== false) {
    print_r($bANKCARDCUSTOMERCREDITORREFUND->getResult());
} else {
    print_r($bANKCARDCUSTOMERCREDITORREFUND->getLastError());
}
/**
 * Samples for BANKCARDCUSTOMERCREDIT ServiceType
 */
$bANKCARDCUSTOMERCREDIT = new \ServiceType\BANKCARDCUSTOMERCREDIT($options);
/**
 * Sample call for BANKCARD_CUSTOMER_CREDIT operation/method
 */
if ($bANKCARDCUSTOMERCREDIT->BANKCARD_CUSTOMER_CREDIT(new \StructType\BANKCARD_CUSTOMER_CREDIT()) !== false) {
    print_r($bANKCARDCUSTOMERCREDIT->getResult());
} else {
    print_r($bANKCARDCUSTOMERCREDIT->getLastError());
}
/**
 * Samples for BANKCARDCUSTOMERVOID ServiceType
 */
$bANKCARDCUSTOMERVOID = new \ServiceType\BANKCARDCUSTOMERVOID($options);
/**
 * Sample call for BANKCARD_CUSTOMER_VOID operation/method
 */
if ($bANKCARDCUSTOMERVOID->BANKCARD_CUSTOMER_VOID(new \StructType\BANKCARD_CUSTOMER_VOID()) !== false) {
    print_r($bANKCARDCUSTOMERVOID->getResult());
} else {
    print_r($bANKCARDCUSTOMERVOID->getLastError());
}
/**
 * Samples for BANKCARDCUSTOMERPRIORAUTHSALE ServiceType
 */
$bANKCARDCUSTOMERPRIORAUTHSALE = new \ServiceType\BANKCARDCUSTOMERPRIORAUTHSALE($options);
/**
 * Sample call for BANKCARD_CUSTOMER_PRIOR_AUTH_SALE operation/method
 */
if ($bANKCARDCUSTOMERPRIORAUTHSALE->BANKCARD_CUSTOMER_PRIOR_AUTH_SALE(new \StructType\BANKCARD_CUSTOMER_PRIOR_AUTH_SALE()) !== false) {
    print_r($bANKCARDCUSTOMERPRIORAUTHSALE->getResult());
} else {
    print_r($bANKCARDCUSTOMERPRIORAUTHSALE->getLastError());
}
/**
 * Samples for VERIFYBANKCARDCUSTOMERSERVICE ServiceType
 */
$vERIFYBANKCARDCUSTOMERSERVICE = new \ServiceType\VERIFYBANKCARDCUSTOMERSERVICE($options);
/**
 * Sample call for VERIFY_BANKCARD_CUSTOMER_SERVICE operation/method
 */
if ($vERIFYBANKCARDCUSTOMERSERVICE->VERIFY_BANKCARD_CUSTOMER_SERVICE(new \StructType\VERIFY_BANKCARD_CUSTOMER_SERVICE()) !== false) {
    print_r($vERIFYBANKCARDCUSTOMERSERVICE->getResult());
} else {
    print_r($vERIFYBANKCARDCUSTOMERSERVICE->getLastError());
}
/**
 * Samples for VIEWSETTLEDBATCHSUMMARY ServiceType
 */
$vIEWSETTLEDBATCHSUMMARY = new \ServiceType\VIEWSETTLEDBATCHSUMMARY($options);
/**
 * Sample call for VIEW_SETTLED_BATCH_SUMMARY operation/method
 */
if ($vIEWSETTLEDBATCHSUMMARY->VIEW_SETTLED_BATCH_SUMMARY(new \StructType\VIEW_SETTLED_BATCH_SUMMARY()) !== false) {
    print_r($vIEWSETTLEDBATCHSUMMARY->getResult());
} else {
    print_r($vIEWSETTLEDBATCHSUMMARY->getLastError());
}
/**
 * Samples for VIEWBANKCARDSETTLEDBATCHLISTING ServiceType
 */
$vIEWBANKCARDSETTLEDBATCHLISTING = new \ServiceType\VIEWBANKCARDSETTLEDBATCHLISTING($options);
/**
 * Sample call for VIEW_BANKCARD_SETTLED_BATCH_LISTING operation/method
 */
if ($vIEWBANKCARDSETTLEDBATCHLISTING->VIEW_BANKCARD_SETTLED_BATCH_LISTING(new \StructType\VIEW_BANKCARD_SETTLED_BATCH_LISTING()) !== false) {
    print_r($vIEWBANKCARDSETTLEDBATCHLISTING->getResult());
} else {
    print_r($vIEWBANKCARDSETTLEDBATCHLISTING->getLastError());
}
/**
 * Samples for GIFTCARDACTIVATION ServiceType
 */
$gIFTCARDACTIVATION = new \ServiceType\GIFTCARDACTIVATION($options);
/**
 * Sample call for GIFTCARD_ACTIVATION operation/method
 */
if ($gIFTCARDACTIVATION->GIFTCARD_ACTIVATION(new \StructType\GIFTCARD_ACTIVATION()) !== false) {
    print_r($gIFTCARDACTIVATION->getResult());
} else {
    print_r($gIFTCARDACTIVATION->getLastError());
}
/**
 * Samples for GIFTCARDREDEMPTION ServiceType
 */
$gIFTCARDREDEMPTION = new \ServiceType\GIFTCARDREDEMPTION($options);
/**
 * Sample call for GIFTCARD_REDEMPTION operation/method
 */
if ($gIFTCARDREDEMPTION->GIFTCARD_REDEMPTION(new \StructType\GIFTCARD_REDEMPTION()) !== false) {
    print_r($gIFTCARDREDEMPTION->getResult());
} else {
    print_r($gIFTCARDREDEMPTION->getLastError());
}
/**
 * Samples for GIFTCARDVOID ServiceType
 */
$gIFTCARDVOID = new \ServiceType\GIFTCARDVOID($options);
/**
 * Sample call for GIFTCARD_VOID operation/method
 */
if ($gIFTCARDVOID->GIFTCARD_VOID(new \StructType\GIFTCARD_VOID()) !== false) {
    print_r($gIFTCARDVOID->getResult());
} else {
    print_r($gIFTCARDVOID->getLastError());
}
/**
 * Samples for GIFTCARDBALANCE ServiceType
 */
$gIFTCARDBALANCE = new \ServiceType\GIFTCARDBALANCE($options);
/**
 * Sample call for GIFTCARD_BALANCE operation/method
 */
if ($gIFTCARDBALANCE->GIFTCARD_BALANCE(new \StructType\GIFTCARD_BALANCE()) !== false) {
    print_r($gIFTCARDBALANCE->getResult());
} else {
    print_r($gIFTCARDBALANCE->getLastError());
}
/**
 * Samples for VERIFYGIFTCARDSERVICE ServiceType
 */
$vERIFYGIFTCARDSERVICE = new \ServiceType\VERIFYGIFTCARDSERVICE($options);
/**
 * Sample call for VERIFY_GIFTCARD_SERVICE operation/method
 */
if ($vERIFYGIFTCARDSERVICE->VERIFY_GIFTCARD_SERVICE(new \StructType\VERIFY_GIFTCARD_SERVICE()) !== false) {
    print_r($vERIFYGIFTCARDSERVICE->getResult());
} else {
    print_r($vERIFYGIFTCARDSERVICE->getLastError());
}
/**
 * Samples for FINANCEAPPLICATION ServiceType
 */
$fINANCEAPPLICATION = new \ServiceType\FINANCEAPPLICATION($options);
/**
 * Sample call for FINANCE_APPLICATION operation/method
 */
if ($fINANCEAPPLICATION->FINANCE_APPLICATION(new \StructType\FINANCE_APPLICATION()) !== false) {
    print_r($fINANCEAPPLICATION->getResult());
} else {
    print_r($fINANCEAPPLICATION->getLastError());
}
/**
 * Samples for FINANCEPROMODISCLOSURE ServiceType
 */
$fINANCEPROMODISCLOSURE = new \ServiceType\FINANCEPROMODISCLOSURE($options);
/**
 * Sample call for FINANCE_PROMO_DISCLOSURE operation/method
 */
if ($fINANCEPROMODISCLOSURE->FINANCE_PROMO_DISCLOSURE(new \StructType\FINANCE_PROMO_DISCLOSURE()) !== false) {
    print_r($fINANCEPROMODISCLOSURE->getResult());
} else {
    print_r($fINANCEPROMODISCLOSURE->getLastError());
}
/**
 * Samples for FINANCEAUTHORIZATION ServiceType
 */
$fINANCEAUTHORIZATION = new \ServiceType\FINANCEAUTHORIZATION($options);
/**
 * Sample call for FINANCE_AUTHORIZATION operation/method
 */
if ($fINANCEAUTHORIZATION->FINANCE_AUTHORIZATION(new \StructType\FINANCE_AUTHORIZATION()) !== false) {
    print_r($fINANCEAUTHORIZATION->getResult());
} else {
    print_r($fINANCEAUTHORIZATION->getLastError());
}
/**
 * Samples for FINANCEREVERSEAUTH ServiceType
 */
$fINANCEREVERSEAUTH = new \ServiceType\FINANCEREVERSEAUTH($options);
/**
 * Sample call for FINANCE_REVERSE_AUTH operation/method
 */
if ($fINANCEREVERSEAUTH->FINANCE_REVERSE_AUTH(new \StructType\FINANCE_REVERSE_AUTH()) !== false) {
    print_r($fINANCEREVERSEAUTH->getResult());
} else {
    print_r($fINANCEREVERSEAUTH->getLastError());
}
/**
 * Samples for FINANCESETTLEMENT ServiceType
 */
$fINANCESETTLEMENT = new \ServiceType\FINANCESETTLEMENT($options);
/**
 * Sample call for FINANCE_SETTLEMENT operation/method
 */
if ($fINANCESETTLEMENT->FINANCE_SETTLEMENT(new \StructType\FINANCE_SETTLEMENT()) !== false) {
    print_r($fINANCESETTLEMENT->getResult());
} else {
    print_r($fINANCESETTLEMENT->getLastError());
}
/**
 * Samples for FINANCERECONCILE ServiceType
 */
$fINANCERECONCILE = new \ServiceType\FINANCERECONCILE($options);
/**
 * Sample call for FINANCE_RECONCILE operation/method
 */
if ($fINANCERECONCILE->FINANCE_RECONCILE(new \StructType\FINANCE_RECONCILE()) !== false) {
    print_r($fINANCERECONCILE->getResult());
} else {
    print_r($fINANCERECONCILE->getLastError());
}
/**
 * Samples for BANKCARDLEVELSALE ServiceType
 */
$bANKCARDLEVELSALE = new \ServiceType\BANKCARDLEVELSALE($options);
/**
 * Sample call for BANKCARD_LEVEL3_SALE operation/method
 */
if ($bANKCARDLEVELSALE->BANKCARD_LEVEL3_SALE(new \StructType\BANKCARD_LEVEL3_SALE()) !== false) {
    print_r($bANKCARDLEVELSALE->getResult());
} else {
    print_r($bANKCARDLEVELSALE->getLastError());
}
/**
 * Samples for BANKCARDLEVELAUTHONLY ServiceType
 */
$bANKCARDLEVELAUTHONLY = new \ServiceType\BANKCARDLEVELAUTHONLY($options);
/**
 * Sample call for BANKCARD_LEVEL3_AUTHONLY operation/method
 */
if ($bANKCARDLEVELAUTHONLY->BANKCARD_LEVEL3_AUTHONLY(new \StructType\BANKCARD_LEVEL3_AUTHONLY()) !== false) {
    print_r($bANKCARDLEVELAUTHONLY->getResult());
} else {
    print_r($bANKCARDLEVELAUTHONLY->getLastError());
}
/**
 * Samples for BANKCARDLEVELPRIORAUTHSALE ServiceType
 */
$bANKCARDLEVELPRIORAUTHSALE = new \ServiceType\BANKCARDLEVELPRIORAUTHSALE($options);
/**
 * Sample call for BANKCARD_LEVEL3_PRIOR_AUTH_SALE operation/method
 */
if ($bANKCARDLEVELPRIORAUTHSALE->BANKCARD_LEVEL3_PRIOR_AUTH_SALE(new \StructType\BANKCARD_LEVEL3_PRIOR_AUTH_SALE()) !== false) {
    print_r($bANKCARDLEVELPRIORAUTHSALE->getResult());
} else {
    print_r($bANKCARDLEVELPRIORAUTHSALE->getLastError());
}
/**
 * Samples for BANKCARDLEVELPHONEAUTHPOST ServiceType
 */
$bANKCARDLEVELPHONEAUTHPOST = new \ServiceType\BANKCARDLEVELPHONEAUTHPOST($options);
/**
 * Sample call for BANKCARD_LEVEL3_PHONE_AUTH_POST operation/method
 */
if ($bANKCARDLEVELPHONEAUTHPOST->BANKCARD_LEVEL3_PHONE_AUTH_POST(new \StructType\BANKCARD_LEVEL3_PHONE_AUTH_POST()) !== false) {
    print_r($bANKCARDLEVELPHONEAUTHPOST->getResult());
} else {
    print_r($bANKCARDLEVELPHONEAUTHPOST->getLastError());
}
/**
 * Samples for BANKCARDLEVELCREDIT ServiceType
 */
$bANKCARDLEVELCREDIT = new \ServiceType\BANKCARDLEVELCREDIT($options);
/**
 * Sample call for BANKCARD_LEVEL3_CREDIT operation/method
 */
if ($bANKCARDLEVELCREDIT->BANKCARD_LEVEL3_CREDIT(new \StructType\BANKCARD_LEVEL3_CREDIT()) !== false) {
    print_r($bANKCARDLEVELCREDIT->getResult());
} else {
    print_r($bANKCARDLEVELCREDIT->getLastError());
}
/**
 * Samples for BANKCARDLEVELVOID ServiceType
 */
$bANKCARDLEVELVOID = new \ServiceType\BANKCARDLEVELVOID($options);
/**
 * Sample call for BANKCARD_LEVEL3_VOID operation/method
 */
if ($bANKCARDLEVELVOID->BANKCARD_LEVEL3_VOID(new \StructType\BANKCARD_LEVEL3_VOID()) !== false) {
    print_r($bANKCARDLEVELVOID->getResult());
} else {
    print_r($bANKCARDLEVELVOID->getLastError());
}
/**
 * Samples for VERIFYBANKCARDLEVELSERVICE ServiceType
 */
$vERIFYBANKCARDLEVELSERVICE = new \ServiceType\VERIFYBANKCARDLEVELSERVICE($options);
/**
 * Sample call for VERIFY_BANKCARD_LEVEL3_SERVICE operation/method
 */
if ($vERIFYBANKCARDLEVELSERVICE->VERIFY_BANKCARD_LEVEL3_SERVICE(new \StructType\VERIFY_BANKCARD_LEVEL3_SERVICE()) !== false) {
    print_r($vERIFYBANKCARDLEVELSERVICE->getResult());
} else {
    print_r($vERIFYBANKCARDLEVELSERVICE->getLastError());
}
