<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GIFTCARD_BALANCE StructType
 * @subpackage Structs
 */
class GIFTCARD_BALANCE extends AbstractStructBase
{
    /**
     * The MerchantID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MerchantID;
    /**
     * The HashInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\HashInput
     */
    public $HashInfo;
    /**
     * The GiftCardNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GiftCardNumber;
    /**
     * The ClientIP
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientIP;
    /**
     * The Program
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Program;
    /**
     * Constructor method for GIFTCARD_BALANCE
     * @uses GIFTCARD_BALANCE::setMerchantID()
     * @uses GIFTCARD_BALANCE::setHashInfo()
     * @uses GIFTCARD_BALANCE::setGiftCardNumber()
     * @uses GIFTCARD_BALANCE::setClientIP()
     * @uses GIFTCARD_BALANCE::setProgram()
     * @param string $merchantID
     * @param \StructType\HashInput $hashInfo
     * @param string $giftCardNumber
     * @param string $clientIP
     * @param string $program
     */
    public function __construct($merchantID = null, \StructType\HashInput $hashInfo = null, $giftCardNumber = null, $clientIP = null, $program = null)
    {
        $this
            ->setMerchantID($merchantID)
            ->setHashInfo($hashInfo)
            ->setGiftCardNumber($giftCardNumber)
            ->setClientIP($clientIP)
            ->setProgram($program);
    }
    /**
     * Get MerchantID value
     * @return string
     */
    public function getMerchantID()
    {
        return $this->MerchantID;
    }
    /**
     * Set MerchantID value
     * @param string $merchantID
     * @return \StructType\GIFTCARD_BALANCE
     */
    public function setMerchantID($merchantID = null)
    {
        // validation for constraint: string
        if (!is_null($merchantID) && !is_string($merchantID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantID, true), gettype($merchantID)), __LINE__);
        }
        $this->MerchantID = $merchantID;
        return $this;
    }
    /**
     * Get HashInfo value
     * @return \StructType\HashInput
     */
    public function getHashInfo()
    {
        return $this->HashInfo;
    }
    /**
     * Set HashInfo value
     * @param \StructType\HashInput $hashInfo
     * @return \StructType\GIFTCARD_BALANCE
     */
    public function setHashInfo(\StructType\HashInput $hashInfo = null)
    {
        $this->HashInfo = $hashInfo;
        return $this;
    }
    /**
     * Get GiftCardNumber value
     * @return string
     */
    public function getGiftCardNumber()
    {
        return $this->GiftCardNumber;
    }
    /**
     * Set GiftCardNumber value
     * @param string $giftCardNumber
     * @return \StructType\GIFTCARD_BALANCE
     */
    public function setGiftCardNumber($giftCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($giftCardNumber) && !is_string($giftCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftCardNumber, true), gettype($giftCardNumber)), __LINE__);
        }
        $this->GiftCardNumber = $giftCardNumber;
        return $this;
    }
    /**
     * Get ClientIP value
     * @return string|null
     */
    public function getClientIP()
    {
        return $this->ClientIP;
    }
    /**
     * Set ClientIP value
     * @param string $clientIP
     * @return \StructType\GIFTCARD_BALANCE
     */
    public function setClientIP($clientIP = null)
    {
        // validation for constraint: string
        if (!is_null($clientIP) && !is_string($clientIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientIP, true), gettype($clientIP)), __LINE__);
        }
        $this->ClientIP = $clientIP;
        return $this;
    }
    /**
     * Get Program value
     * @return string|null
     */
    public function getProgram()
    {
        return $this->Program;
    }
    /**
     * Set Program value
     * @param string $program
     * @return \StructType\GIFTCARD_BALANCE
     */
    public function setProgram($program = null)
    {
        // validation for constraint: string
        if (!is_null($program) && !is_string($program)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($program, true), gettype($program)), __LINE__);
        }
        $this->Program = $program;
        return $this;
    }
}
