<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FINANCE_PROMO_DISCLOSURE StructType
 * @subpackage Structs
 */
class FINANCE_PROMO_DISCLOSURE extends AbstractStructBase
{
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $UserID;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Password;
    /**
     * The MerchantID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MerchantID;
    /**
     * The HashInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\HashInput
     */
    public $HashInfo;
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AccountNumber;
    /**
     * The ProductCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ProductCode;
    /**
     * The PurchaseAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PurchaseAmount;
    /**
     * Constructor method for FINANCE_PROMO_DISCLOSURE
     * @uses FINANCE_PROMO_DISCLOSURE::setUserID()
     * @uses FINANCE_PROMO_DISCLOSURE::setPassword()
     * @uses FINANCE_PROMO_DISCLOSURE::setMerchantID()
     * @uses FINANCE_PROMO_DISCLOSURE::setHashInfo()
     * @uses FINANCE_PROMO_DISCLOSURE::setAccountNumber()
     * @uses FINANCE_PROMO_DISCLOSURE::setProductCode()
     * @uses FINANCE_PROMO_DISCLOSURE::setPurchaseAmount()
     * @param string $userID
     * @param string $password
     * @param string $merchantID
     * @param \StructType\HashInput $hashInfo
     * @param string $accountNumber
     * @param string $productCode
     * @param float $purchaseAmount
     */
    public function __construct($userID = null, $password = null, $merchantID = null, \StructType\HashInput $hashInfo = null, $accountNumber = null, $productCode = null, $purchaseAmount = null)
    {
        $this
            ->setUserID($userID)
            ->setPassword($password)
            ->setMerchantID($merchantID)
            ->setHashInfo($hashInfo)
            ->setAccountNumber($accountNumber)
            ->setProductCode($productCode)
            ->setPurchaseAmount($purchaseAmount);
    }
    /**
     * Get UserID value
     * @return string
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param string $userID
     * @return \StructType\FINANCE_PROMO_DISCLOSURE
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: string
        if (!is_null($userID) && !is_string($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get Password value
     * @return string
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\FINANCE_PROMO_DISCLOSURE
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get MerchantID value
     * @return string
     */
    public function getMerchantID()
    {
        return $this->MerchantID;
    }
    /**
     * Set MerchantID value
     * @param string $merchantID
     * @return \StructType\FINANCE_PROMO_DISCLOSURE
     */
    public function setMerchantID($merchantID = null)
    {
        // validation for constraint: string
        if (!is_null($merchantID) && !is_string($merchantID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantID, true), gettype($merchantID)), __LINE__);
        }
        $this->MerchantID = $merchantID;
        return $this;
    }
    /**
     * Get HashInfo value
     * @return \StructType\HashInput
     */
    public function getHashInfo()
    {
        return $this->HashInfo;
    }
    /**
     * Set HashInfo value
     * @param \StructType\HashInput $hashInfo
     * @return \StructType\FINANCE_PROMO_DISCLOSURE
     */
    public function setHashInfo(\StructType\HashInput $hashInfo = null)
    {
        $this->HashInfo = $hashInfo;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \StructType\FINANCE_PROMO_DISCLOSURE
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get ProductCode value
     * @return string
     */
    public function getProductCode()
    {
        return $this->ProductCode;
    }
    /**
     * Set ProductCode value
     * @param string $productCode
     * @return \StructType\FINANCE_PROMO_DISCLOSURE
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCode) && !is_string($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productCode, true), gettype($productCode)), __LINE__);
        }
        $this->ProductCode = $productCode;
        return $this;
    }
    /**
     * Get PurchaseAmount value
     * @return float
     */
    public function getPurchaseAmount()
    {
        return $this->PurchaseAmount;
    }
    /**
     * Set PurchaseAmount value
     * @param float $purchaseAmount
     * @return \StructType\FINANCE_PROMO_DISCLOSURE
     */
    public function setPurchaseAmount($purchaseAmount = null)
    {
        // validation for constraint: float
        if (!is_null($purchaseAmount) && !(is_float($purchaseAmount) || is_numeric($purchaseAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($purchaseAmount, true), gettype($purchaseAmount)), __LINE__);
        }
        $this->PurchaseAmount = $purchaseAmount;
        return $this;
    }
}
