<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BatchListingOutput StructType
 * @subpackage Structs
 */
class BatchListingOutput extends AbstractStructBase
{
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * The Zip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Zip;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The EmailAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailAddress;
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhoneNumber;
    /**
     * The FaxNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FaxNumber;
    /**
     * The ShipAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShipAddress;
    /**
     * The ShipCity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShipCity;
    /**
     * The ShipState
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShipState;
    /**
     * The ShipZip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShipZip;
    /**
     * The ShipCountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShipCountry;
    /**
     * The CreditCardNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreditCardNumber;
    /**
     * The CardExpiration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardExpiration;
    /**
     * The Approved
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Approved;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The AuthCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AuthCode;
    /**
     * The Invoice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoice;
    /**
     * The AvsCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AvsCode;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $TotalAmount;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $TaxAmount;
    /**
     * The ShippingAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $ShippingAmount;
    /**
     * The SettleDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SettleDate;
    /**
     * The CardType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardType;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReferenceNumber;
    /**
     * The BatchNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BatchNumber;
    /**
     * The CustomerNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerNumber;
    /**
     * Constructor method for BatchListingOutput
     * @uses BatchListingOutput::setDate()
     * @uses BatchListingOutput::setName()
     * @uses BatchListingOutput::setAddress()
     * @uses BatchListingOutput::setCity()
     * @uses BatchListingOutput::setState()
     * @uses BatchListingOutput::setZip()
     * @uses BatchListingOutput::setCountry()
     * @uses BatchListingOutput::setEmailAddress()
     * @uses BatchListingOutput::setPhoneNumber()
     * @uses BatchListingOutput::setFaxNumber()
     * @uses BatchListingOutput::setShipAddress()
     * @uses BatchListingOutput::setShipCity()
     * @uses BatchListingOutput::setShipState()
     * @uses BatchListingOutput::setShipZip()
     * @uses BatchListingOutput::setShipCountry()
     * @uses BatchListingOutput::setCreditCardNumber()
     * @uses BatchListingOutput::setCardExpiration()
     * @uses BatchListingOutput::setApproved()
     * @uses BatchListingOutput::setMessage()
     * @uses BatchListingOutput::setAuthCode()
     * @uses BatchListingOutput::setInvoice()
     * @uses BatchListingOutput::setAvsCode()
     * @uses BatchListingOutput::setStatusCode()
     * @uses BatchListingOutput::setTotalAmount()
     * @uses BatchListingOutput::setTaxAmount()
     * @uses BatchListingOutput::setShippingAmount()
     * @uses BatchListingOutput::setSettleDate()
     * @uses BatchListingOutput::setCardType()
     * @uses BatchListingOutput::setReferenceNumber()
     * @uses BatchListingOutput::setBatchNumber()
     * @uses BatchListingOutput::setCustomerNumber()
     * @param string $date
     * @param string $name
     * @param string $address
     * @param string $city
     * @param string $state
     * @param string $zip
     * @param string $country
     * @param string $emailAddress
     * @param string $phoneNumber
     * @param string $faxNumber
     * @param string $shipAddress
     * @param string $shipCity
     * @param string $shipState
     * @param string $shipZip
     * @param string $shipCountry
     * @param string $creditCardNumber
     * @param string $cardExpiration
     * @param string $approved
     * @param string $message
     * @param string $authCode
     * @param string $invoice
     * @param string $avsCode
     * @param string $statusCode
     * @param float $totalAmount
     * @param float $taxAmount
     * @param float $shippingAmount
     * @param string $settleDate
     * @param string $cardType
     * @param string $referenceNumber
     * @param string $batchNumber
     * @param string $customerNumber
     */
    public function __construct($date = null, $name = null, $address = null, $city = null, $state = null, $zip = null, $country = null, $emailAddress = null, $phoneNumber = null, $faxNumber = null, $shipAddress = null, $shipCity = null, $shipState = null, $shipZip = null, $shipCountry = null, $creditCardNumber = null, $cardExpiration = null, $approved = null, $message = null, $authCode = null, $invoice = null, $avsCode = null, $statusCode = null, $totalAmount = null, $taxAmount = null, $shippingAmount = null, $settleDate = null, $cardType = null, $referenceNumber = null, $batchNumber = null, $customerNumber = null)
    {
        $this
            ->setDate($date)
            ->setName($name)
            ->setAddress($address)
            ->setCity($city)
            ->setState($state)
            ->setZip($zip)
            ->setCountry($country)
            ->setEmailAddress($emailAddress)
            ->setPhoneNumber($phoneNumber)
            ->setFaxNumber($faxNumber)
            ->setShipAddress($shipAddress)
            ->setShipCity($shipCity)
            ->setShipState($shipState)
            ->setShipZip($shipZip)
            ->setShipCountry($shipCountry)
            ->setCreditCardNumber($creditCardNumber)
            ->setCardExpiration($cardExpiration)
            ->setApproved($approved)
            ->setMessage($message)
            ->setAuthCode($authCode)
            ->setInvoice($invoice)
            ->setAvsCode($avsCode)
            ->setStatusCode($statusCode)
            ->setTotalAmount($totalAmount)
            ->setTaxAmount($taxAmount)
            ->setShippingAmount($shippingAmount)
            ->setSettleDate($settleDate)
            ->setCardType($cardType)
            ->setReferenceNumber($referenceNumber)
            ->setBatchNumber($batchNumber)
            ->setCustomerNumber($customerNumber);
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\BatchListingOutput
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\BatchListingOutput
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\BatchListingOutput
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\BatchListingOutput
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \StructType\BatchListingOutput
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get Zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->Zip;
    }
    /**
     * Set Zip value
     * @param string $zip
     * @return \StructType\BatchListingOutput
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zip, true), gettype($zip)), __LINE__);
        }
        $this->Zip = $zip;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\BatchListingOutput
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \StructType\BatchListingOutput
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAddress, true), gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \StructType\BatchListingOutput
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get FaxNumber value
     * @return string|null
     */
    public function getFaxNumber()
    {
        return $this->FaxNumber;
    }
    /**
     * Set FaxNumber value
     * @param string $faxNumber
     * @return \StructType\BatchListingOutput
     */
    public function setFaxNumber($faxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($faxNumber) && !is_string($faxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faxNumber, true), gettype($faxNumber)), __LINE__);
        }
        $this->FaxNumber = $faxNumber;
        return $this;
    }
    /**
     * Get ShipAddress value
     * @return string|null
     */
    public function getShipAddress()
    {
        return $this->ShipAddress;
    }
    /**
     * Set ShipAddress value
     * @param string $shipAddress
     * @return \StructType\BatchListingOutput
     */
    public function setShipAddress($shipAddress = null)
    {
        // validation for constraint: string
        if (!is_null($shipAddress) && !is_string($shipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipAddress, true), gettype($shipAddress)), __LINE__);
        }
        $this->ShipAddress = $shipAddress;
        return $this;
    }
    /**
     * Get ShipCity value
     * @return string|null
     */
    public function getShipCity()
    {
        return $this->ShipCity;
    }
    /**
     * Set ShipCity value
     * @param string $shipCity
     * @return \StructType\BatchListingOutput
     */
    public function setShipCity($shipCity = null)
    {
        // validation for constraint: string
        if (!is_null($shipCity) && !is_string($shipCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipCity, true), gettype($shipCity)), __LINE__);
        }
        $this->ShipCity = $shipCity;
        return $this;
    }
    /**
     * Get ShipState value
     * @return string|null
     */
    public function getShipState()
    {
        return $this->ShipState;
    }
    /**
     * Set ShipState value
     * @param string $shipState
     * @return \StructType\BatchListingOutput
     */
    public function setShipState($shipState = null)
    {
        // validation for constraint: string
        if (!is_null($shipState) && !is_string($shipState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipState, true), gettype($shipState)), __LINE__);
        }
        $this->ShipState = $shipState;
        return $this;
    }
    /**
     * Get ShipZip value
     * @return string|null
     */
    public function getShipZip()
    {
        return $this->ShipZip;
    }
    /**
     * Set ShipZip value
     * @param string $shipZip
     * @return \StructType\BatchListingOutput
     */
    public function setShipZip($shipZip = null)
    {
        // validation for constraint: string
        if (!is_null($shipZip) && !is_string($shipZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipZip, true), gettype($shipZip)), __LINE__);
        }
        $this->ShipZip = $shipZip;
        return $this;
    }
    /**
     * Get ShipCountry value
     * @return string|null
     */
    public function getShipCountry()
    {
        return $this->ShipCountry;
    }
    /**
     * Set ShipCountry value
     * @param string $shipCountry
     * @return \StructType\BatchListingOutput
     */
    public function setShipCountry($shipCountry = null)
    {
        // validation for constraint: string
        if (!is_null($shipCountry) && !is_string($shipCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipCountry, true), gettype($shipCountry)), __LINE__);
        }
        $this->ShipCountry = $shipCountry;
        return $this;
    }
    /**
     * Get CreditCardNumber value
     * @return string|null
     */
    public function getCreditCardNumber()
    {
        return $this->CreditCardNumber;
    }
    /**
     * Set CreditCardNumber value
     * @param string $creditCardNumber
     * @return \StructType\BatchListingOutput
     */
    public function setCreditCardNumber($creditCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardNumber) && !is_string($creditCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditCardNumber, true), gettype($creditCardNumber)), __LINE__);
        }
        $this->CreditCardNumber = $creditCardNumber;
        return $this;
    }
    /**
     * Get CardExpiration value
     * @return string|null
     */
    public function getCardExpiration()
    {
        return $this->CardExpiration;
    }
    /**
     * Set CardExpiration value
     * @param string $cardExpiration
     * @return \StructType\BatchListingOutput
     */
    public function setCardExpiration($cardExpiration = null)
    {
        // validation for constraint: string
        if (!is_null($cardExpiration) && !is_string($cardExpiration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardExpiration, true), gettype($cardExpiration)), __LINE__);
        }
        $this->CardExpiration = $cardExpiration;
        return $this;
    }
    /**
     * Get Approved value
     * @return string|null
     */
    public function getApproved()
    {
        return $this->Approved;
    }
    /**
     * Set Approved value
     * @param string $approved
     * @return \StructType\BatchListingOutput
     */
    public function setApproved($approved = null)
    {
        // validation for constraint: string
        if (!is_null($approved) && !is_string($approved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approved, true), gettype($approved)), __LINE__);
        }
        $this->Approved = $approved;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\BatchListingOutput
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get AuthCode value
     * @return string|null
     */
    public function getAuthCode()
    {
        return $this->AuthCode;
    }
    /**
     * Set AuthCode value
     * @param string $authCode
     * @return \StructType\BatchListingOutput
     */
    public function setAuthCode($authCode = null)
    {
        // validation for constraint: string
        if (!is_null($authCode) && !is_string($authCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authCode, true), gettype($authCode)), __LINE__);
        }
        $this->AuthCode = $authCode;
        return $this;
    }
    /**
     * Get Invoice value
     * @return string|null
     */
    public function getInvoice()
    {
        return $this->Invoice;
    }
    /**
     * Set Invoice value
     * @param string $invoice
     * @return \StructType\BatchListingOutput
     */
    public function setInvoice($invoice = null)
    {
        // validation for constraint: string
        if (!is_null($invoice) && !is_string($invoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice, true), gettype($invoice)), __LINE__);
        }
        $this->Invoice = $invoice;
        return $this;
    }
    /**
     * Get AvsCode value
     * @return string|null
     */
    public function getAvsCode()
    {
        return $this->AvsCode;
    }
    /**
     * Set AvsCode value
     * @param string $avsCode
     * @return \StructType\BatchListingOutput
     */
    public function setAvsCode($avsCode = null)
    {
        // validation for constraint: string
        if (!is_null($avsCode) && !is_string($avsCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($avsCode, true), gettype($avsCode)), __LINE__);
        }
        $this->AvsCode = $avsCode;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \StructType\BatchListingOutput
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return float|null
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param float $totalAmount
     * @return \StructType\BatchListingOutput
     */
    public function setTotalAmount($totalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalAmount) && !(is_float($totalAmount) || is_numeric($totalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAmount, true), gettype($totalAmount)), __LINE__);
        }
        $this->TotalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param float $taxAmount
     * @return \StructType\BatchListingOutput
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get ShippingAmount value
     * @return float|null
     */
    public function getShippingAmount()
    {
        return $this->ShippingAmount;
    }
    /**
     * Set ShippingAmount value
     * @param float $shippingAmount
     * @return \StructType\BatchListingOutput
     */
    public function setShippingAmount($shippingAmount = null)
    {
        // validation for constraint: float
        if (!is_null($shippingAmount) && !(is_float($shippingAmount) || is_numeric($shippingAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shippingAmount, true), gettype($shippingAmount)), __LINE__);
        }
        $this->ShippingAmount = $shippingAmount;
        return $this;
    }
    /**
     * Get SettleDate value
     * @return string|null
     */
    public function getSettleDate()
    {
        return $this->SettleDate;
    }
    /**
     * Set SettleDate value
     * @param string $settleDate
     * @return \StructType\BatchListingOutput
     */
    public function setSettleDate($settleDate = null)
    {
        // validation for constraint: string
        if (!is_null($settleDate) && !is_string($settleDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($settleDate, true), gettype($settleDate)), __LINE__);
        }
        $this->SettleDate = $settleDate;
        return $this;
    }
    /**
     * Get CardType value
     * @return string|null
     */
    public function getCardType()
    {
        return $this->CardType;
    }
    /**
     * Set CardType value
     * @param string $cardType
     * @return \StructType\BatchListingOutput
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardType, true), gettype($cardType)), __LINE__);
        }
        $this->CardType = $cardType;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param string $referenceNumber
     * @return \StructType\BatchListingOutput
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get BatchNumber value
     * @return string|null
     */
    public function getBatchNumber()
    {
        return $this->BatchNumber;
    }
    /**
     * Set BatchNumber value
     * @param string $batchNumber
     * @return \StructType\BatchListingOutput
     */
    public function setBatchNumber($batchNumber = null)
    {
        // validation for constraint: string
        if (!is_null($batchNumber) && !is_string($batchNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchNumber, true), gettype($batchNumber)), __LINE__);
        }
        $this->BatchNumber = $batchNumber;
        return $this;
    }
    /**
     * Get CustomerNumber value
     * @return string|null
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }
    /**
     * Set CustomerNumber value
     * @param string $customerNumber
     * @return \StructType\BatchListingOutput
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customerNumber) && !is_string($customerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerNumber, true), gettype($customerNumber)), __LINE__);
        }
        $this->CustomerNumber = $customerNumber;
        return $this;
    }
}
