<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BankCardResponse StructType
 * @subpackage Structs
 */
class BankCardResponse extends AbstractStructBase
{
    /**
     * The ApprovalIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ApprovalIndicator;
    /**
     * The AuthCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AuthCode;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Message;
    /**
     * The CVVIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CVVIndicator;
    /**
     * The AVSIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AVSIndicator;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ErrorCode;
    /**
     * The BatchNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BatchNumber;
    /**
     * The AcsUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AcsUrl;
    /**
     * The Payload
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Payload;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReferenceNumber;
    /**
     * Constructor method for BankCardResponse
     * @uses BankCardResponse::setApprovalIndicator()
     * @uses BankCardResponse::setAuthCode()
     * @uses BankCardResponse::setMessage()
     * @uses BankCardResponse::setCVVIndicator()
     * @uses BankCardResponse::setAVSIndicator()
     * @uses BankCardResponse::setErrorCode()
     * @uses BankCardResponse::setBatchNumber()
     * @uses BankCardResponse::setAcsUrl()
     * @uses BankCardResponse::setPayload()
     * @uses BankCardResponse::setReferenceNumber()
     * @param string $approvalIndicator
     * @param string $authCode
     * @param string $message
     * @param string $cVVIndicator
     * @param string $aVSIndicator
     * @param string $errorCode
     * @param string $batchNumber
     * @param string $acsUrl
     * @param string $payload
     * @param string $referenceNumber
     */
    public function __construct($approvalIndicator = null, $authCode = null, $message = null, $cVVIndicator = null, $aVSIndicator = null, $errorCode = null, $batchNumber = null, $acsUrl = null, $payload = null, $referenceNumber = null)
    {
        $this
            ->setApprovalIndicator($approvalIndicator)
            ->setAuthCode($authCode)
            ->setMessage($message)
            ->setCVVIndicator($cVVIndicator)
            ->setAVSIndicator($aVSIndicator)
            ->setErrorCode($errorCode)
            ->setBatchNumber($batchNumber)
            ->setAcsUrl($acsUrl)
            ->setPayload($payload)
            ->setReferenceNumber($referenceNumber);
    }
    /**
     * Get ApprovalIndicator value
     * @return string
     */
    public function getApprovalIndicator()
    {
        return $this->ApprovalIndicator;
    }
    /**
     * Set ApprovalIndicator value
     * @param string $approvalIndicator
     * @return \StructType\BankCardResponse
     */
    public function setApprovalIndicator($approvalIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($approvalIndicator) && !is_string($approvalIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approvalIndicator, true), gettype($approvalIndicator)), __LINE__);
        }
        $this->ApprovalIndicator = $approvalIndicator;
        return $this;
    }
    /**
     * Get AuthCode value
     * @return string
     */
    public function getAuthCode()
    {
        return $this->AuthCode;
    }
    /**
     * Set AuthCode value
     * @param string $authCode
     * @return \StructType\BankCardResponse
     */
    public function setAuthCode($authCode = null)
    {
        // validation for constraint: string
        if (!is_null($authCode) && !is_string($authCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authCode, true), gettype($authCode)), __LINE__);
        }
        $this->AuthCode = $authCode;
        return $this;
    }
    /**
     * Get Message value
     * @return string
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\BankCardResponse
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get CVVIndicator value
     * @return string
     */
    public function getCVVIndicator()
    {
        return $this->CVVIndicator;
    }
    /**
     * Set CVVIndicator value
     * @param string $cVVIndicator
     * @return \StructType\BankCardResponse
     */
    public function setCVVIndicator($cVVIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($cVVIndicator) && !is_string($cVVIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cVVIndicator, true), gettype($cVVIndicator)), __LINE__);
        }
        $this->CVVIndicator = $cVVIndicator;
        return $this;
    }
    /**
     * Get AVSIndicator value
     * @return string
     */
    public function getAVSIndicator()
    {
        return $this->AVSIndicator;
    }
    /**
     * Set AVSIndicator value
     * @param string $aVSIndicator
     * @return \StructType\BankCardResponse
     */
    public function setAVSIndicator($aVSIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($aVSIndicator) && !is_string($aVSIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aVSIndicator, true), gettype($aVSIndicator)), __LINE__);
        }
        $this->AVSIndicator = $aVSIndicator;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return string
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param string $errorCode
     * @return \StructType\BankCardResponse
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get BatchNumber value
     * @return string
     */
    public function getBatchNumber()
    {
        return $this->BatchNumber;
    }
    /**
     * Set BatchNumber value
     * @param string $batchNumber
     * @return \StructType\BankCardResponse
     */
    public function setBatchNumber($batchNumber = null)
    {
        // validation for constraint: string
        if (!is_null($batchNumber) && !is_string($batchNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchNumber, true), gettype($batchNumber)), __LINE__);
        }
        $this->BatchNumber = $batchNumber;
        return $this;
    }
    /**
     * Get AcsUrl value
     * @return string
     */
    public function getAcsUrl()
    {
        return $this->AcsUrl;
    }
    /**
     * Set AcsUrl value
     * @param string $acsUrl
     * @return \StructType\BankCardResponse
     */
    public function setAcsUrl($acsUrl = null)
    {
        // validation for constraint: string
        if (!is_null($acsUrl) && !is_string($acsUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acsUrl, true), gettype($acsUrl)), __LINE__);
        }
        $this->AcsUrl = $acsUrl;
        return $this;
    }
    /**
     * Get Payload value
     * @return string
     */
    public function getPayload()
    {
        return $this->Payload;
    }
    /**
     * Set Payload value
     * @param string $payload
     * @return \StructType\BankCardResponse
     */
    public function setPayload($payload = null)
    {
        // validation for constraint: string
        if (!is_null($payload) && !is_string($payload)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payload, true), gettype($payload)), __LINE__);
        }
        $this->Payload = $payload;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return string
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param string $referenceNumber
     * @return \StructType\BankCardResponse
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
}
