<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BANKCARD_VERIFY_CUSTOMER_PAYMENT_METHOD StructType
 * @subpackage Structs
 */
class BANKCARD_VERIFY_CUSTOMER_PAYMENT_METHOD extends AbstractStructBase
{
    /**
     * The MerchantID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MerchantID;
    /**
     * The HashInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\HashInput
     */
    public $HashInfo;
    /**
     * The ClientIP
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientIP;
    /**
     * The CreditCardInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CreditCardInput
     */
    public $CreditCardInfo;
    /**
     * The CheckInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CheckInput
     */
    public $CheckInfo;
    /**
     * Constructor method for BANKCARD_VERIFY_CUSTOMER_PAYMENT_METHOD
     * @uses BANKCARD_VERIFY_CUSTOMER_PAYMENT_METHOD::setMerchantID()
     * @uses BANKCARD_VERIFY_CUSTOMER_PAYMENT_METHOD::setHashInfo()
     * @uses BANKCARD_VERIFY_CUSTOMER_PAYMENT_METHOD::setClientIP()
     * @uses BANKCARD_VERIFY_CUSTOMER_PAYMENT_METHOD::setCreditCardInfo()
     * @uses BANKCARD_VERIFY_CUSTOMER_PAYMENT_METHOD::setCheckInfo()
     * @param string $merchantID
     * @param \StructType\HashInput $hashInfo
     * @param string $clientIP
     * @param \StructType\CreditCardInput $creditCardInfo
     * @param \StructType\CheckInput $checkInfo
     */
    public function __construct($merchantID = null, \StructType\HashInput $hashInfo = null, $clientIP = null, \StructType\CreditCardInput $creditCardInfo = null, \StructType\CheckInput $checkInfo = null)
    {
        $this
            ->setMerchantID($merchantID)
            ->setHashInfo($hashInfo)
            ->setClientIP($clientIP)
            ->setCreditCardInfo($creditCardInfo)
            ->setCheckInfo($checkInfo);
    }
    /**
     * Get MerchantID value
     * @return string
     */
    public function getMerchantID()
    {
        return $this->MerchantID;
    }
    /**
     * Set MerchantID value
     * @param string $merchantID
     * @return \StructType\BANKCARD_VERIFY_CUSTOMER_PAYMENT_METHOD
     */
    public function setMerchantID($merchantID = null)
    {
        // validation for constraint: string
        if (!is_null($merchantID) && !is_string($merchantID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantID, true), gettype($merchantID)), __LINE__);
        }
        $this->MerchantID = $merchantID;
        return $this;
    }
    /**
     * Get HashInfo value
     * @return \StructType\HashInput
     */
    public function getHashInfo()
    {
        return $this->HashInfo;
    }
    /**
     * Set HashInfo value
     * @param \StructType\HashInput $hashInfo
     * @return \StructType\BANKCARD_VERIFY_CUSTOMER_PAYMENT_METHOD
     */
    public function setHashInfo(\StructType\HashInput $hashInfo = null)
    {
        $this->HashInfo = $hashInfo;
        return $this;
    }
    /**
     * Get ClientIP value
     * @return string|null
     */
    public function getClientIP()
    {
        return $this->ClientIP;
    }
    /**
     * Set ClientIP value
     * @param string $clientIP
     * @return \StructType\BANKCARD_VERIFY_CUSTOMER_PAYMENT_METHOD
     */
    public function setClientIP($clientIP = null)
    {
        // validation for constraint: string
        if (!is_null($clientIP) && !is_string($clientIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientIP, true), gettype($clientIP)), __LINE__);
        }
        $this->ClientIP = $clientIP;
        return $this;
    }
    /**
     * Get CreditCardInfo value
     * @return \StructType\CreditCardInput|null
     */
    public function getCreditCardInfo()
    {
        return $this->CreditCardInfo;
    }
    /**
     * Set CreditCardInfo value
     * @param \StructType\CreditCardInput $creditCardInfo
     * @return \StructType\BANKCARD_VERIFY_CUSTOMER_PAYMENT_METHOD
     */
    public function setCreditCardInfo(\StructType\CreditCardInput $creditCardInfo = null)
    {
        $this->CreditCardInfo = $creditCardInfo;
        return $this;
    }
    /**
     * Get CheckInfo value
     * @return \StructType\CheckInput|null
     */
    public function getCheckInfo()
    {
        return $this->CheckInfo;
    }
    /**
     * Set CheckInfo value
     * @param \StructType\CheckInput $checkInfo
     * @return \StructType\BANKCARD_VERIFY_CUSTOMER_PAYMENT_METHOD
     */
    public function setCheckInfo(\StructType\CheckInput $checkInfo = null)
    {
        $this->CheckInfo = $checkInfo;
        return $this;
    }
}
