<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BANKCARD_GET_CUSTOMERResult StructType
 * @subpackage Structs
 */
class BANKCARD_GET_CUSTOMERResult extends AbstractStructBase
{
    /**
     * The PaymentMethods
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\PaymentMethodInput[]
     */
    public $PaymentMethods;
    /**
     * The CustDBNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CustDBNum;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Error;
    /**
     * The BillingDetailInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CustDetailInput
     */
    public $BillingDetailInfo;
    /**
     * The CustomerDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerDescription;
    /**
     * Constructor method for BANKCARD_GET_CUSTOMERResult
     * @uses BANKCARD_GET_CUSTOMERResult::setPaymentMethods()
     * @uses BANKCARD_GET_CUSTOMERResult::setCustDBNum()
     * @uses BANKCARD_GET_CUSTOMERResult::setError()
     * @uses BANKCARD_GET_CUSTOMERResult::setBillingDetailInfo()
     * @uses BANKCARD_GET_CUSTOMERResult::setCustomerDescription()
     * @param \StructType\PaymentMethodInput[] $paymentMethods
     * @param string $custDBNum
     * @param string $error
     * @param \StructType\CustDetailInput $billingDetailInfo
     * @param string $customerDescription
     */
    public function __construct(array $paymentMethods = array(), $custDBNum = null, $error = null, \StructType\CustDetailInput $billingDetailInfo = null, $customerDescription = null)
    {
        $this
            ->setPaymentMethods($paymentMethods)
            ->setCustDBNum($custDBNum)
            ->setError($error)
            ->setBillingDetailInfo($billingDetailInfo)
            ->setCustomerDescription($customerDescription);
    }
    /**
     * Get PaymentMethods value
     * @return \StructType\PaymentMethodInput[]
     */
    public function getPaymentMethods()
    {
        return $this->PaymentMethods;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentMethods method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentMethods method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentMethodsForArrayConstraintsFromSetPaymentMethods(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bANKCARD_GET_CUSTOMERResultPaymentMethodsItem) {
            // validation for constraint: itemType
            if (!$bANKCARD_GET_CUSTOMERResultPaymentMethodsItem instanceof \StructType\PaymentMethodInput) {
                $invalidValues[] = is_object($bANKCARD_GET_CUSTOMERResultPaymentMethodsItem) ? get_class($bANKCARD_GET_CUSTOMERResultPaymentMethodsItem) : sprintf('%s(%s)', gettype($bANKCARD_GET_CUSTOMERResultPaymentMethodsItem), var_export($bANKCARD_GET_CUSTOMERResultPaymentMethodsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentMethods property can only contain items of type \StructType\PaymentMethodInput, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentMethods value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentMethodInput[] $paymentMethods
     * @return \StructType\BANKCARD_GET_CUSTOMERResult
     */
    public function setPaymentMethods(array $paymentMethods = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentMethodsArrayErrorMessage = self::validatePaymentMethodsForArrayConstraintsFromSetPaymentMethods($paymentMethods))) {
            throw new \InvalidArgumentException($paymentMethodsArrayErrorMessage, __LINE__);
        }
        $this->PaymentMethods = $paymentMethods;
        return $this;
    }
    /**
     * Add item to PaymentMethods value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentMethodInput $item
     * @return \StructType\BANKCARD_GET_CUSTOMERResult
     */
    public function addToPaymentMethods(\StructType\PaymentMethodInput $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentMethodInput) {
            throw new \InvalidArgumentException(sprintf('The PaymentMethods property can only contain items of type \StructType\PaymentMethodInput, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentMethods[] = $item;
        return $this;
    }
    /**
     * Get CustDBNum value
     * @return string
     */
    public function getCustDBNum()
    {
        return $this->CustDBNum;
    }
    /**
     * Set CustDBNum value
     * @param string $custDBNum
     * @return \StructType\BANKCARD_GET_CUSTOMERResult
     */
    public function setCustDBNum($custDBNum = null)
    {
        // validation for constraint: string
        if (!is_null($custDBNum) && !is_string($custDBNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($custDBNum, true), gettype($custDBNum)), __LINE__);
        }
        $this->CustDBNum = $custDBNum;
        return $this;
    }
    /**
     * Get Error value
     * @return string
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @param string $error
     * @return \StructType\BANKCARD_GET_CUSTOMERResult
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error, true), gettype($error)), __LINE__);
        }
        $this->Error = $error;
        return $this;
    }
    /**
     * Get BillingDetailInfo value
     * @return \StructType\CustDetailInput|null
     */
    public function getBillingDetailInfo()
    {
        return $this->BillingDetailInfo;
    }
    /**
     * Set BillingDetailInfo value
     * @param \StructType\CustDetailInput $billingDetailInfo
     * @return \StructType\BANKCARD_GET_CUSTOMERResult
     */
    public function setBillingDetailInfo(\StructType\CustDetailInput $billingDetailInfo = null)
    {
        $this->BillingDetailInfo = $billingDetailInfo;
        return $this;
    }
    /**
     * Get CustomerDescription value
     * @return string|null
     */
    public function getCustomerDescription()
    {
        return $this->CustomerDescription;
    }
    /**
     * Set CustomerDescription value
     * @param string $customerDescription
     * @return \StructType\BANKCARD_GET_CUSTOMERResult
     */
    public function setCustomerDescription($customerDescription = null)
    {
        // validation for constraint: string
        if (!is_null($customerDescription) && !is_string($customerDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerDescription, true), gettype($customerDescription)), __LINE__);
        }
        $this->CustomerDescription = $customerDescription;
        return $this;
    }
}
