<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BANKCARD_DEL_CUSTOMERResult StructType
 * @subpackage Structs
 */
class BANKCARD_DEL_CUSTOMERResult extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The RemovedFlag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RemovedFlag;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Error;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Message;
    /**
     * Constructor method for BANKCARD_DEL_CUSTOMERResult
     * @uses BANKCARD_DEL_CUSTOMERResult::setStatus()
     * @uses BANKCARD_DEL_CUSTOMERResult::setRemovedFlag()
     * @uses BANKCARD_DEL_CUSTOMERResult::setError()
     * @uses BANKCARD_DEL_CUSTOMERResult::setMessage()
     * @param string $status
     * @param int $removedFlag
     * @param string $error
     * @param string $message
     */
    public function __construct($status = null, $removedFlag = null, $error = null, $message = null)
    {
        $this
            ->setStatus($status)
            ->setRemovedFlag($removedFlag)
            ->setError($error)
            ->setMessage($message);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\BANKCARD_DEL_CUSTOMERResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get RemovedFlag value
     * @return int
     */
    public function getRemovedFlag()
    {
        return $this->RemovedFlag;
    }
    /**
     * Set RemovedFlag value
     * @param int $removedFlag
     * @return \StructType\BANKCARD_DEL_CUSTOMERResult
     */
    public function setRemovedFlag($removedFlag = null)
    {
        // validation for constraint: int
        if (!is_null($removedFlag) && !(is_int($removedFlag) || ctype_digit($removedFlag))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($removedFlag, true), gettype($removedFlag)), __LINE__);
        }
        $this->RemovedFlag = $removedFlag;
        return $this;
    }
    /**
     * Get Error value
     * @return string
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @param string $error
     * @return \StructType\BANKCARD_DEL_CUSTOMERResult
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error, true), gettype($error)), __LINE__);
        }
        $this->Error = $error;
        return $this;
    }
    /**
     * Get Message value
     * @return string
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\BANKCARD_DEL_CUSTOMERResult
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
}
