<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BANKCARD_CUSTOMER_CREDIT_OR_REFUND StructType
 * @subpackage Structs
 */
class BANKCARD_CUSTOMER_CREDIT_OR_REFUND extends AbstractStructBase
{
    /**
     * The MerchantID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MerchantID;
    /**
     * The HashInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\HashInput
     */
    public $HashInfo;
    /**
     * The ClientIP
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientIP;
    /**
     * The CustomerChargeInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CustomerChargeInput
     */
    public $CustomerChargeInfo;
    /**
     * Constructor method for BANKCARD_CUSTOMER_CREDIT_OR_REFUND
     * @uses BANKCARD_CUSTOMER_CREDIT_OR_REFUND::setMerchantID()
     * @uses BANKCARD_CUSTOMER_CREDIT_OR_REFUND::setHashInfo()
     * @uses BANKCARD_CUSTOMER_CREDIT_OR_REFUND::setClientIP()
     * @uses BANKCARD_CUSTOMER_CREDIT_OR_REFUND::setCustomerChargeInfo()
     * @param string $merchantID
     * @param \StructType\HashInput $hashInfo
     * @param string $clientIP
     * @param \StructType\CustomerChargeInput $customerChargeInfo
     */
    public function __construct($merchantID = null, \StructType\HashInput $hashInfo = null, $clientIP = null, \StructType\CustomerChargeInput $customerChargeInfo = null)
    {
        $this
            ->setMerchantID($merchantID)
            ->setHashInfo($hashInfo)
            ->setClientIP($clientIP)
            ->setCustomerChargeInfo($customerChargeInfo);
    }
    /**
     * Get MerchantID value
     * @return string
     */
    public function getMerchantID()
    {
        return $this->MerchantID;
    }
    /**
     * Set MerchantID value
     * @param string $merchantID
     * @return \StructType\BANKCARD_CUSTOMER_CREDIT_OR_REFUND
     */
    public function setMerchantID($merchantID = null)
    {
        // validation for constraint: string
        if (!is_null($merchantID) && !is_string($merchantID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantID, true), gettype($merchantID)), __LINE__);
        }
        $this->MerchantID = $merchantID;
        return $this;
    }
    /**
     * Get HashInfo value
     * @return \StructType\HashInput
     */
    public function getHashInfo()
    {
        return $this->HashInfo;
    }
    /**
     * Set HashInfo value
     * @param \StructType\HashInput $hashInfo
     * @return \StructType\BANKCARD_CUSTOMER_CREDIT_OR_REFUND
     */
    public function setHashInfo(\StructType\HashInput $hashInfo = null)
    {
        $this->HashInfo = $hashInfo;
        return $this;
    }
    /**
     * Get ClientIP value
     * @return string|null
     */
    public function getClientIP()
    {
        return $this->ClientIP;
    }
    /**
     * Set ClientIP value
     * @param string $clientIP
     * @return \StructType\BANKCARD_CUSTOMER_CREDIT_OR_REFUND
     */
    public function setClientIP($clientIP = null)
    {
        // validation for constraint: string
        if (!is_null($clientIP) && !is_string($clientIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientIP, true), gettype($clientIP)), __LINE__);
        }
        $this->ClientIP = $clientIP;
        return $this;
    }
    /**
     * Get CustomerChargeInfo value
     * @return \StructType\CustomerChargeInput|null
     */
    public function getCustomerChargeInfo()
    {
        return $this->CustomerChargeInfo;
    }
    /**
     * Set CustomerChargeInfo value
     * @param \StructType\CustomerChargeInput $customerChargeInfo
     * @return \StructType\BANKCARD_CUSTOMER_CREDIT_OR_REFUND
     */
    public function setCustomerChargeInfo(\StructType\CustomerChargeInput $customerChargeInfo = null)
    {
        $this->CustomerChargeInfo = $customerChargeInfo;
        return $this;
    }
}
