<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BANKCARD_AUTHONLYL3 StructType
 * @subpackage Structs
 */
class BANKCARD_AUTHONLYL3 extends AbstractStructBase
{
    /**
     * The MerchantID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MerchantID;
    /**
     * The HashInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\HashInput
     */
    public $HashInfo;
    /**
     * The ClientIP
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientIP;
    /**
     * The ChargeDetailInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ChargeDetailInput
     */
    public $ChargeDetailInfo;
    /**
     * The BillingDetailInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CustDetailInput
     */
    public $BillingDetailInfo;
    /**
     * The ShippingDetailInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CustDetailInput
     */
    public $ShippingDetailInfo;
    /**
     * The ItemDetailInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ItemDetailInput[]
     */
    public $ItemDetailInfo;
    /**
     * Constructor method for BANKCARD_AUTHONLYL3
     * @uses BANKCARD_AUTHONLYL3::setMerchantID()
     * @uses BANKCARD_AUTHONLYL3::setHashInfo()
     * @uses BANKCARD_AUTHONLYL3::setClientIP()
     * @uses BANKCARD_AUTHONLYL3::setChargeDetailInfo()
     * @uses BANKCARD_AUTHONLYL3::setBillingDetailInfo()
     * @uses BANKCARD_AUTHONLYL3::setShippingDetailInfo()
     * @uses BANKCARD_AUTHONLYL3::setItemDetailInfo()
     * @param string $merchantID
     * @param \StructType\HashInput $hashInfo
     * @param string $clientIP
     * @param \StructType\ChargeDetailInput $chargeDetailInfo
     * @param \StructType\CustDetailInput $billingDetailInfo
     * @param \StructType\CustDetailInput $shippingDetailInfo
     * @param \StructType\ItemDetailInput[] $itemDetailInfo
     */
    public function __construct($merchantID = null, \StructType\HashInput $hashInfo = null, $clientIP = null, \StructType\ChargeDetailInput $chargeDetailInfo = null, \StructType\CustDetailInput $billingDetailInfo = null, \StructType\CustDetailInput $shippingDetailInfo = null, array $itemDetailInfo = array())
    {
        $this
            ->setMerchantID($merchantID)
            ->setHashInfo($hashInfo)
            ->setClientIP($clientIP)
            ->setChargeDetailInfo($chargeDetailInfo)
            ->setBillingDetailInfo($billingDetailInfo)
            ->setShippingDetailInfo($shippingDetailInfo)
            ->setItemDetailInfo($itemDetailInfo);
    }
    /**
     * Get MerchantID value
     * @return string
     */
    public function getMerchantID()
    {
        return $this->MerchantID;
    }
    /**
     * Set MerchantID value
     * @param string $merchantID
     * @return \StructType\BANKCARD_AUTHONLYL3
     */
    public function setMerchantID($merchantID = null)
    {
        // validation for constraint: string
        if (!is_null($merchantID) && !is_string($merchantID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantID, true), gettype($merchantID)), __LINE__);
        }
        $this->MerchantID = $merchantID;
        return $this;
    }
    /**
     * Get HashInfo value
     * @return \StructType\HashInput
     */
    public function getHashInfo()
    {
        return $this->HashInfo;
    }
    /**
     * Set HashInfo value
     * @param \StructType\HashInput $hashInfo
     * @return \StructType\BANKCARD_AUTHONLYL3
     */
    public function setHashInfo(\StructType\HashInput $hashInfo = null)
    {
        $this->HashInfo = $hashInfo;
        return $this;
    }
    /**
     * Get ClientIP value
     * @return string|null
     */
    public function getClientIP()
    {
        return $this->ClientIP;
    }
    /**
     * Set ClientIP value
     * @param string $clientIP
     * @return \StructType\BANKCARD_AUTHONLYL3
     */
    public function setClientIP($clientIP = null)
    {
        // validation for constraint: string
        if (!is_null($clientIP) && !is_string($clientIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientIP, true), gettype($clientIP)), __LINE__);
        }
        $this->ClientIP = $clientIP;
        return $this;
    }
    /**
     * Get ChargeDetailInfo value
     * @return \StructType\ChargeDetailInput|null
     */
    public function getChargeDetailInfo()
    {
        return $this->ChargeDetailInfo;
    }
    /**
     * Set ChargeDetailInfo value
     * @param \StructType\ChargeDetailInput $chargeDetailInfo
     * @return \StructType\BANKCARD_AUTHONLYL3
     */
    public function setChargeDetailInfo(\StructType\ChargeDetailInput $chargeDetailInfo = null)
    {
        $this->ChargeDetailInfo = $chargeDetailInfo;
        return $this;
    }
    /**
     * Get BillingDetailInfo value
     * @return \StructType\CustDetailInput|null
     */
    public function getBillingDetailInfo()
    {
        return $this->BillingDetailInfo;
    }
    /**
     * Set BillingDetailInfo value
     * @param \StructType\CustDetailInput $billingDetailInfo
     * @return \StructType\BANKCARD_AUTHONLYL3
     */
    public function setBillingDetailInfo(\StructType\CustDetailInput $billingDetailInfo = null)
    {
        $this->BillingDetailInfo = $billingDetailInfo;
        return $this;
    }
    /**
     * Get ShippingDetailInfo value
     * @return \StructType\CustDetailInput|null
     */
    public function getShippingDetailInfo()
    {
        return $this->ShippingDetailInfo;
    }
    /**
     * Set ShippingDetailInfo value
     * @param \StructType\CustDetailInput $shippingDetailInfo
     * @return \StructType\BANKCARD_AUTHONLYL3
     */
    public function setShippingDetailInfo(\StructType\CustDetailInput $shippingDetailInfo = null)
    {
        $this->ShippingDetailInfo = $shippingDetailInfo;
        return $this;
    }
    /**
     * Get ItemDetailInfo value
     * @return \StructType\ItemDetailInput[]|null
     */
    public function getItemDetailInfo()
    {
        return $this->ItemDetailInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setItemDetailInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemDetailInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemDetailInfoForArrayConstraintsFromSetItemDetailInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bANKCARD_AUTHONLYL3ItemDetailInfoItem) {
            // validation for constraint: itemType
            if (!$bANKCARD_AUTHONLYL3ItemDetailInfoItem instanceof \StructType\ItemDetailInput) {
                $invalidValues[] = is_object($bANKCARD_AUTHONLYL3ItemDetailInfoItem) ? get_class($bANKCARD_AUTHONLYL3ItemDetailInfoItem) : sprintf('%s(%s)', gettype($bANKCARD_AUTHONLYL3ItemDetailInfoItem), var_export($bANKCARD_AUTHONLYL3ItemDetailInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemDetailInfo property can only contain items of type \StructType\ItemDetailInput, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItemDetailInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemDetailInput[] $itemDetailInfo
     * @return \StructType\BANKCARD_AUTHONLYL3
     */
    public function setItemDetailInfo(array $itemDetailInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($itemDetailInfoArrayErrorMessage = self::validateItemDetailInfoForArrayConstraintsFromSetItemDetailInfo($itemDetailInfo))) {
            throw new \InvalidArgumentException($itemDetailInfoArrayErrorMessage, __LINE__);
        }
        $this->ItemDetailInfo = $itemDetailInfo;
        return $this;
    }
    /**
     * Add item to ItemDetailInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemDetailInput $item
     * @return \StructType\BANKCARD_AUTHONLYL3
     */
    public function addToItemDetailInfo(\StructType\ItemDetailInput $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemDetailInput) {
            throw new \InvalidArgumentException(sprintf('The ItemDetailInfo property can only contain items of type \StructType\ItemDetailInput, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemDetailInfo[] = $item;
        return $this;
    }
}
