<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VIEW_BANKCARD_SETTLED_BATCH_LISTING StructType
 * @subpackage Structs
 */
class VIEW_BANKCARD_SETTLED_BATCH_LISTING extends AbstractStructBase
{
    /**
     * The MerchantID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MerchantID;
    /**
     * The HashInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\HashInput
     */
    public $HashInfo;
    /**
     * The ClientIP
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientIP;
    /**
     * The BatchReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BatchReference;
    /**
     * Constructor method for VIEW_BANKCARD_SETTLED_BATCH_LISTING
     * @uses VIEW_BANKCARD_SETTLED_BATCH_LISTING::setMerchantID()
     * @uses VIEW_BANKCARD_SETTLED_BATCH_LISTING::setHashInfo()
     * @uses VIEW_BANKCARD_SETTLED_BATCH_LISTING::setClientIP()
     * @uses VIEW_BANKCARD_SETTLED_BATCH_LISTING::setBatchReference()
     * @param string $merchantID
     * @param \StructType\HashInput $hashInfo
     * @param string $clientIP
     * @param string $batchReference
     */
    public function __construct($merchantID = null, \StructType\HashInput $hashInfo = null, $clientIP = null, $batchReference = null)
    {
        $this
            ->setMerchantID($merchantID)
            ->setHashInfo($hashInfo)
            ->setClientIP($clientIP)
            ->setBatchReference($batchReference);
    }
    /**
     * Get MerchantID value
     * @return string
     */
    public function getMerchantID()
    {
        return $this->MerchantID;
    }
    /**
     * Set MerchantID value
     * @param string $merchantID
     * @return \StructType\VIEW_BANKCARD_SETTLED_BATCH_LISTING
     */
    public function setMerchantID($merchantID = null)
    {
        // validation for constraint: string
        if (!is_null($merchantID) && !is_string($merchantID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantID, true), gettype($merchantID)), __LINE__);
        }
        $this->MerchantID = $merchantID;
        return $this;
    }
    /**
     * Get HashInfo value
     * @return \StructType\HashInput
     */
    public function getHashInfo()
    {
        return $this->HashInfo;
    }
    /**
     * Set HashInfo value
     * @param \StructType\HashInput $hashInfo
     * @return \StructType\VIEW_BANKCARD_SETTLED_BATCH_LISTING
     */
    public function setHashInfo(\StructType\HashInput $hashInfo = null)
    {
        $this->HashInfo = $hashInfo;
        return $this;
    }
    /**
     * Get ClientIP value
     * @return string|null
     */
    public function getClientIP()
    {
        return $this->ClientIP;
    }
    /**
     * Set ClientIP value
     * @param string $clientIP
     * @return \StructType\VIEW_BANKCARD_SETTLED_BATCH_LISTING
     */
    public function setClientIP($clientIP = null)
    {
        // validation for constraint: string
        if (!is_null($clientIP) && !is_string($clientIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientIP, true), gettype($clientIP)), __LINE__);
        }
        $this->ClientIP = $clientIP;
        return $this;
    }
    /**
     * Get BatchReference value
     * @return string|null
     */
    public function getBatchReference()
    {
        return $this->BatchReference;
    }
    /**
     * Set BatchReference value
     * @param string $batchReference
     * @return \StructType\VIEW_BANKCARD_SETTLED_BATCH_LISTING
     */
    public function setBatchReference($batchReference = null)
    {
        // validation for constraint: string
        if (!is_null($batchReference) && !is_string($batchReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchReference, true), gettype($batchReference)), __LINE__);
        }
        $this->BatchReference = $batchReference;
        return $this;
    }
}
