<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GiftCardResponse StructType
 * @subpackage Structs
 */
class GiftCardResponse extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The AuthCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AuthCode;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReferenceNumber;
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Result;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ErrorCode;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Error;
    /**
     * The Command
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Command;
    /**
     * The GiftCardBalance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GiftCardBalance;
    /**
     * The PointsBalance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PointsBalance;
    /**
     * The RewardCashBalance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RewardCashBalance;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Amount;
    /**
     * The Card
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Card;
    /**
     * The Invoice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Invoice;
    /**
     * Constructor method for GiftCardResponse
     * @uses GiftCardResponse::setStatus()
     * @uses GiftCardResponse::setAuthCode()
     * @uses GiftCardResponse::setReferenceNumber()
     * @uses GiftCardResponse::setResult()
     * @uses GiftCardResponse::setErrorCode()
     * @uses GiftCardResponse::setError()
     * @uses GiftCardResponse::setCommand()
     * @uses GiftCardResponse::setGiftCardBalance()
     * @uses GiftCardResponse::setPointsBalance()
     * @uses GiftCardResponse::setRewardCashBalance()
     * @uses GiftCardResponse::setAmount()
     * @uses GiftCardResponse::setCard()
     * @uses GiftCardResponse::setInvoice()
     * @param string $status
     * @param string $authCode
     * @param string $referenceNumber
     * @param string $result
     * @param string $errorCode
     * @param string $error
     * @param string $command
     * @param string $giftCardBalance
     * @param string $pointsBalance
     * @param string $rewardCashBalance
     * @param string $amount
     * @param string $card
     * @param string $invoice
     */
    public function __construct($status = null, $authCode = null, $referenceNumber = null, $result = null, $errorCode = null, $error = null, $command = null, $giftCardBalance = null, $pointsBalance = null, $rewardCashBalance = null, $amount = null, $card = null, $invoice = null)
    {
        $this
            ->setStatus($status)
            ->setAuthCode($authCode)
            ->setReferenceNumber($referenceNumber)
            ->setResult($result)
            ->setErrorCode($errorCode)
            ->setError($error)
            ->setCommand($command)
            ->setGiftCardBalance($giftCardBalance)
            ->setPointsBalance($pointsBalance)
            ->setRewardCashBalance($rewardCashBalance)
            ->setAmount($amount)
            ->setCard($card)
            ->setInvoice($invoice);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\GiftCardResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get AuthCode value
     * @return string
     */
    public function getAuthCode()
    {
        return $this->AuthCode;
    }
    /**
     * Set AuthCode value
     * @param string $authCode
     * @return \StructType\GiftCardResponse
     */
    public function setAuthCode($authCode = null)
    {
        // validation for constraint: string
        if (!is_null($authCode) && !is_string($authCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authCode, true), gettype($authCode)), __LINE__);
        }
        $this->AuthCode = $authCode;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return string
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param string $referenceNumber
     * @return \StructType\GiftCardResponse
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get Result value
     * @return string
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param string $result
     * @return \StructType\GiftCardResponse
     */
    public function setResult($result = null)
    {
        // validation for constraint: string
        if (!is_null($result) && !is_string($result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($result, true), gettype($result)), __LINE__);
        }
        $this->Result = $result;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return string
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param string $errorCode
     * @return \StructType\GiftCardResponse
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get Error value
     * @return string
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @param string $error
     * @return \StructType\GiftCardResponse
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error, true), gettype($error)), __LINE__);
        }
        $this->Error = $error;
        return $this;
    }
    /**
     * Get Command value
     * @return string
     */
    public function getCommand()
    {
        return $this->Command;
    }
    /**
     * Set Command value
     * @param string $command
     * @return \StructType\GiftCardResponse
     */
    public function setCommand($command = null)
    {
        // validation for constraint: string
        if (!is_null($command) && !is_string($command)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($command, true), gettype($command)), __LINE__);
        }
        $this->Command = $command;
        return $this;
    }
    /**
     * Get GiftCardBalance value
     * @return string
     */
    public function getGiftCardBalance()
    {
        return $this->GiftCardBalance;
    }
    /**
     * Set GiftCardBalance value
     * @param string $giftCardBalance
     * @return \StructType\GiftCardResponse
     */
    public function setGiftCardBalance($giftCardBalance = null)
    {
        // validation for constraint: string
        if (!is_null($giftCardBalance) && !is_string($giftCardBalance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftCardBalance, true), gettype($giftCardBalance)), __LINE__);
        }
        $this->GiftCardBalance = $giftCardBalance;
        return $this;
    }
    /**
     * Get PointsBalance value
     * @return string
     */
    public function getPointsBalance()
    {
        return $this->PointsBalance;
    }
    /**
     * Set PointsBalance value
     * @param string $pointsBalance
     * @return \StructType\GiftCardResponse
     */
    public function setPointsBalance($pointsBalance = null)
    {
        // validation for constraint: string
        if (!is_null($pointsBalance) && !is_string($pointsBalance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pointsBalance, true), gettype($pointsBalance)), __LINE__);
        }
        $this->PointsBalance = $pointsBalance;
        return $this;
    }
    /**
     * Get RewardCashBalance value
     * @return string
     */
    public function getRewardCashBalance()
    {
        return $this->RewardCashBalance;
    }
    /**
     * Set RewardCashBalance value
     * @param string $rewardCashBalance
     * @return \StructType\GiftCardResponse
     */
    public function setRewardCashBalance($rewardCashBalance = null)
    {
        // validation for constraint: string
        if (!is_null($rewardCashBalance) && !is_string($rewardCashBalance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rewardCashBalance, true), gettype($rewardCashBalance)), __LINE__);
        }
        $this->RewardCashBalance = $rewardCashBalance;
        return $this;
    }
    /**
     * Get Amount value
     * @return string
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \StructType\GiftCardResponse
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Card value
     * @return string
     */
    public function getCard()
    {
        return $this->Card;
    }
    /**
     * Set Card value
     * @param string $card
     * @return \StructType\GiftCardResponse
     */
    public function setCard($card = null)
    {
        // validation for constraint: string
        if (!is_null($card) && !is_string($card)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($card, true), gettype($card)), __LINE__);
        }
        $this->Card = $card;
        return $this;
    }
    /**
     * Get Invoice value
     * @return string
     */
    public function getInvoice()
    {
        return $this->Invoice;
    }
    /**
     * Set Invoice value
     * @param string $invoice
     * @return \StructType\GiftCardResponse
     */
    public function setInvoice($invoice = null)
    {
        // validation for constraint: string
        if (!is_null($invoice) && !is_string($invoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice, true), gettype($invoice)), __LINE__);
        }
        $this->Invoice = $invoice;
        return $this;
    }
}
