<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GCChargeDetailInput StructType
 * @subpackage Structs
 */
class GCChargeDetailInput extends AbstractStructBase
{
    /**
     * The CardHolder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardHolder;
    /**
     * The GiftCardNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GiftCardNumber;
    /**
     * The MagStripeData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MagStripeData;
    /**
     * The EntryMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EntryMode;
    /**
     * The CustomerNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerNumber;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Amount;
    /**
     * The Tax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Tax;
    /**
     * The OrderNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderNumber;
    /**
     * Constructor method for GCChargeDetailInput
     * @uses GCChargeDetailInput::setCardHolder()
     * @uses GCChargeDetailInput::setGiftCardNumber()
     * @uses GCChargeDetailInput::setMagStripeData()
     * @uses GCChargeDetailInput::setEntryMode()
     * @uses GCChargeDetailInput::setCustomerNumber()
     * @uses GCChargeDetailInput::setAmount()
     * @uses GCChargeDetailInput::setTax()
     * @uses GCChargeDetailInput::setOrderNumber()
     * @param string $cardHolder
     * @param string $giftCardNumber
     * @param string $magStripeData
     * @param string $entryMode
     * @param string $customerNumber
     * @param string $amount
     * @param string $tax
     * @param string $orderNumber
     */
    public function __construct($cardHolder = null, $giftCardNumber = null, $magStripeData = null, $entryMode = null, $customerNumber = null, $amount = null, $tax = null, $orderNumber = null)
    {
        $this
            ->setCardHolder($cardHolder)
            ->setGiftCardNumber($giftCardNumber)
            ->setMagStripeData($magStripeData)
            ->setEntryMode($entryMode)
            ->setCustomerNumber($customerNumber)
            ->setAmount($amount)
            ->setTax($tax)
            ->setOrderNumber($orderNumber);
    }
    /**
     * Get CardHolder value
     * @return string|null
     */
    public function getCardHolder()
    {
        return $this->CardHolder;
    }
    /**
     * Set CardHolder value
     * @param string $cardHolder
     * @return \StructType\GCChargeDetailInput
     */
    public function setCardHolder($cardHolder = null)
    {
        // validation for constraint: string
        if (!is_null($cardHolder) && !is_string($cardHolder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardHolder, true), gettype($cardHolder)), __LINE__);
        }
        $this->CardHolder = $cardHolder;
        return $this;
    }
    /**
     * Get GiftCardNumber value
     * @return string|null
     */
    public function getGiftCardNumber()
    {
        return $this->GiftCardNumber;
    }
    /**
     * Set GiftCardNumber value
     * @param string $giftCardNumber
     * @return \StructType\GCChargeDetailInput
     */
    public function setGiftCardNumber($giftCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($giftCardNumber) && !is_string($giftCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftCardNumber, true), gettype($giftCardNumber)), __LINE__);
        }
        $this->GiftCardNumber = $giftCardNumber;
        return $this;
    }
    /**
     * Get MagStripeData value
     * @return string|null
     */
    public function getMagStripeData()
    {
        return $this->MagStripeData;
    }
    /**
     * Set MagStripeData value
     * @param string $magStripeData
     * @return \StructType\GCChargeDetailInput
     */
    public function setMagStripeData($magStripeData = null)
    {
        // validation for constraint: string
        if (!is_null($magStripeData) && !is_string($magStripeData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($magStripeData, true), gettype($magStripeData)), __LINE__);
        }
        $this->MagStripeData = $magStripeData;
        return $this;
    }
    /**
     * Get EntryMode value
     * @return string|null
     */
    public function getEntryMode()
    {
        return $this->EntryMode;
    }
    /**
     * Set EntryMode value
     * @param string $entryMode
     * @return \StructType\GCChargeDetailInput
     */
    public function setEntryMode($entryMode = null)
    {
        // validation for constraint: string
        if (!is_null($entryMode) && !is_string($entryMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entryMode, true), gettype($entryMode)), __LINE__);
        }
        $this->EntryMode = $entryMode;
        return $this;
    }
    /**
     * Get CustomerNumber value
     * @return string|null
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }
    /**
     * Set CustomerNumber value
     * @param string $customerNumber
     * @return \StructType\GCChargeDetailInput
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customerNumber) && !is_string($customerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerNumber, true), gettype($customerNumber)), __LINE__);
        }
        $this->CustomerNumber = $customerNumber;
        return $this;
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \StructType\GCChargeDetailInput
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Tax value
     * @return string|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @param string $tax
     * @return \StructType\GCChargeDetailInput
     */
    public function setTax($tax = null)
    {
        // validation for constraint: string
        if (!is_null($tax) && !is_string($tax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tax, true), gettype($tax)), __LINE__);
        }
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Get OrderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->OrderNumber;
    }
    /**
     * Set OrderNumber value
     * @param string $orderNumber
     * @return \StructType\GCChargeDetailInput
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        $this->OrderNumber = $orderNumber;
        return $this;
    }
}
