<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerOutput StructType
 * @subpackage Structs
 */
class CustomerOutput extends AbstractStructBase
{
    /**
     * The PaymentMethods
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\PaymentMethodInput[]
     */
    public $PaymentMethods;
    /**
     * The CustomerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CustomerID;
    /**
     * The BillingDetailInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CustDetailInput
     */
    public $BillingDetailInfo;
    /**
     * The CustomerDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerDescription;
    /**
     * Constructor method for CustomerOutput
     * @uses CustomerOutput::setPaymentMethods()
     * @uses CustomerOutput::setCustomerID()
     * @uses CustomerOutput::setBillingDetailInfo()
     * @uses CustomerOutput::setCustomerDescription()
     * @param \StructType\PaymentMethodInput[] $paymentMethods
     * @param string $customerID
     * @param \StructType\CustDetailInput $billingDetailInfo
     * @param string $customerDescription
     */
    public function __construct(array $paymentMethods = array(), $customerID = null, \StructType\CustDetailInput $billingDetailInfo = null, $customerDescription = null)
    {
        $this
            ->setPaymentMethods($paymentMethods)
            ->setCustomerID($customerID)
            ->setBillingDetailInfo($billingDetailInfo)
            ->setCustomerDescription($customerDescription);
    }
    /**
     * Get PaymentMethods value
     * @return \StructType\PaymentMethodInput[]
     */
    public function getPaymentMethods()
    {
        return $this->PaymentMethods;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentMethods method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentMethods method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentMethodsForArrayConstraintsFromSetPaymentMethods(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerOutputPaymentMethodsItem) {
            // validation for constraint: itemType
            if (!$customerOutputPaymentMethodsItem instanceof \StructType\PaymentMethodInput) {
                $invalidValues[] = is_object($customerOutputPaymentMethodsItem) ? get_class($customerOutputPaymentMethodsItem) : sprintf('%s(%s)', gettype($customerOutputPaymentMethodsItem), var_export($customerOutputPaymentMethodsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentMethods property can only contain items of type \StructType\PaymentMethodInput, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentMethods value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentMethodInput[] $paymentMethods
     * @return \StructType\CustomerOutput
     */
    public function setPaymentMethods(array $paymentMethods = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentMethodsArrayErrorMessage = self::validatePaymentMethodsForArrayConstraintsFromSetPaymentMethods($paymentMethods))) {
            throw new \InvalidArgumentException($paymentMethodsArrayErrorMessage, __LINE__);
        }
        $this->PaymentMethods = $paymentMethods;
        return $this;
    }
    /**
     * Add item to PaymentMethods value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentMethodInput $item
     * @return \StructType\CustomerOutput
     */
    public function addToPaymentMethods(\StructType\PaymentMethodInput $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentMethodInput) {
            throw new \InvalidArgumentException(sprintf('The PaymentMethods property can only contain items of type \StructType\PaymentMethodInput, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentMethods[] = $item;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return string
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param string $customerID
     * @return \StructType\CustomerOutput
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: string
        if (!is_null($customerID) && !is_string($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerID, true), gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get BillingDetailInfo value
     * @return \StructType\CustDetailInput|null
     */
    public function getBillingDetailInfo()
    {
        return $this->BillingDetailInfo;
    }
    /**
     * Set BillingDetailInfo value
     * @param \StructType\CustDetailInput $billingDetailInfo
     * @return \StructType\CustomerOutput
     */
    public function setBillingDetailInfo(\StructType\CustDetailInput $billingDetailInfo = null)
    {
        $this->BillingDetailInfo = $billingDetailInfo;
        return $this;
    }
    /**
     * Get CustomerDescription value
     * @return string|null
     */
    public function getCustomerDescription()
    {
        return $this->CustomerDescription;
    }
    /**
     * Set CustomerDescription value
     * @param string $customerDescription
     * @return \StructType\CustomerOutput
     */
    public function setCustomerDescription($customerDescription = null)
    {
        // validation for constraint: string
        if (!is_null($customerDescription) && !is_string($customerDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerDescription, true), gettype($customerDescription)), __LINE__);
        }
        $this->CustomerDescription = $customerDescription;
        return $this;
    }
}
