<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerChargeInput StructType
 * @subpackage Structs
 */
class CustomerChargeInput extends AbstractStructBase
{
    /**
     * The PaymentMethodID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentMethodID;
    /**
     * The CustDBNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CustDBNum;
    /**
     * The CardCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardCode;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Amount;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $TaxAmount;
    /**
     * The OrderNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderNumber;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The CustReceipt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustReceipt;
    /**
     * The CustReceiptTemplate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustReceiptTemplate;
    /**
     * The CustReceiptEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustReceiptEmail;
    /**
     * Constructor method for CustomerChargeInput
     * @uses CustomerChargeInput::setPaymentMethodID()
     * @uses CustomerChargeInput::setCustDBNum()
     * @uses CustomerChargeInput::setCardCode()
     * @uses CustomerChargeInput::setAmount()
     * @uses CustomerChargeInput::setTaxAmount()
     * @uses CustomerChargeInput::setOrderNumber()
     * @uses CustomerChargeInput::setDescription()
     * @uses CustomerChargeInput::setCustReceipt()
     * @uses CustomerChargeInput::setCustReceiptTemplate()
     * @uses CustomerChargeInput::setCustReceiptEmail()
     * @param string $paymentMethodID
     * @param string $custDBNum
     * @param string $cardCode
     * @param float $amount
     * @param float $taxAmount
     * @param string $orderNumber
     * @param string $description
     * @param string $custReceipt
     * @param string $custReceiptTemplate
     * @param string $custReceiptEmail
     */
    public function __construct($paymentMethodID = null, $custDBNum = null, $cardCode = null, $amount = null, $taxAmount = null, $orderNumber = null, $description = null, $custReceipt = null, $custReceiptTemplate = null, $custReceiptEmail = null)
    {
        $this
            ->setPaymentMethodID($paymentMethodID)
            ->setCustDBNum($custDBNum)
            ->setCardCode($cardCode)
            ->setAmount($amount)
            ->setTaxAmount($taxAmount)
            ->setOrderNumber($orderNumber)
            ->setDescription($description)
            ->setCustReceipt($custReceipt)
            ->setCustReceiptTemplate($custReceiptTemplate)
            ->setCustReceiptEmail($custReceiptEmail);
    }
    /**
     * Get PaymentMethodID value
     * @return string
     */
    public function getPaymentMethodID()
    {
        return $this->PaymentMethodID;
    }
    /**
     * Set PaymentMethodID value
     * @param string $paymentMethodID
     * @return \StructType\CustomerChargeInput
     */
    public function setPaymentMethodID($paymentMethodID = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodID) && !is_string($paymentMethodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodID, true), gettype($paymentMethodID)), __LINE__);
        }
        $this->PaymentMethodID = $paymentMethodID;
        return $this;
    }
    /**
     * Get CustDBNum value
     * @return string
     */
    public function getCustDBNum()
    {
        return $this->CustDBNum;
    }
    /**
     * Set CustDBNum value
     * @param string $custDBNum
     * @return \StructType\CustomerChargeInput
     */
    public function setCustDBNum($custDBNum = null)
    {
        // validation for constraint: string
        if (!is_null($custDBNum) && !is_string($custDBNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($custDBNum, true), gettype($custDBNum)), __LINE__);
        }
        $this->CustDBNum = $custDBNum;
        return $this;
    }
    /**
     * Get CardCode value
     * @return string|null
     */
    public function getCardCode()
    {
        return $this->CardCode;
    }
    /**
     * Set CardCode value
     * @param string $cardCode
     * @return \StructType\CustomerChargeInput
     */
    public function setCardCode($cardCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardCode) && !is_string($cardCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardCode, true), gettype($cardCode)), __LINE__);
        }
        $this->CardCode = $cardCode;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\CustomerChargeInput
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param float $taxAmount
     * @return \StructType\CustomerChargeInput
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get OrderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->OrderNumber;
    }
    /**
     * Set OrderNumber value
     * @param string $orderNumber
     * @return \StructType\CustomerChargeInput
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        $this->OrderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\CustomerChargeInput
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get CustReceipt value
     * @return string|null
     */
    public function getCustReceipt()
    {
        return $this->CustReceipt;
    }
    /**
     * Set CustReceipt value
     * @param string $custReceipt
     * @return \StructType\CustomerChargeInput
     */
    public function setCustReceipt($custReceipt = null)
    {
        // validation for constraint: string
        if (!is_null($custReceipt) && !is_string($custReceipt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($custReceipt, true), gettype($custReceipt)), __LINE__);
        }
        $this->CustReceipt = $custReceipt;
        return $this;
    }
    /**
     * Get CustReceiptTemplate value
     * @return string|null
     */
    public function getCustReceiptTemplate()
    {
        return $this->CustReceiptTemplate;
    }
    /**
     * Set CustReceiptTemplate value
     * @param string $custReceiptTemplate
     * @return \StructType\CustomerChargeInput
     */
    public function setCustReceiptTemplate($custReceiptTemplate = null)
    {
        // validation for constraint: string
        if (!is_null($custReceiptTemplate) && !is_string($custReceiptTemplate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($custReceiptTemplate, true), gettype($custReceiptTemplate)), __LINE__);
        }
        $this->CustReceiptTemplate = $custReceiptTemplate;
        return $this;
    }
    /**
     * Get CustReceiptEmail value
     * @return string|null
     */
    public function getCustReceiptEmail()
    {
        return $this->CustReceiptEmail;
    }
    /**
     * Set CustReceiptEmail value
     * @param string $custReceiptEmail
     * @return \StructType\CustomerChargeInput
     */
    public function setCustReceiptEmail($custReceiptEmail = null)
    {
        // validation for constraint: string
        if (!is_null($custReceiptEmail) && !is_string($custReceiptEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($custReceiptEmail, true), gettype($custReceiptEmail)), __LINE__);
        }
        $this->CustReceiptEmail = $custReceiptEmail;
        return $this;
    }
}
