<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckInput StructType
 * @subpackage Structs
 */
class CheckInput extends AbstractStructBase
{
    /**
     * The CheckNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $CheckNumber;
    /**
     * The Routing
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Routing;
    /**
     * The Account
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Account;
    /**
     * The AccountType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountType;
    /**
     * Constructor method for CheckInput
     * @uses CheckInput::setCheckNumber()
     * @uses CheckInput::setRouting()
     * @uses CheckInput::setAccount()
     * @uses CheckInput::setAccountType()
     * @param int $checkNumber
     * @param string $routing
     * @param string $account
     * @param string $accountType
     */
    public function __construct($checkNumber = null, $routing = null, $account = null, $accountType = null)
    {
        $this
            ->setCheckNumber($checkNumber)
            ->setRouting($routing)
            ->setAccount($account)
            ->setAccountType($accountType);
    }
    /**
     * Get CheckNumber value
     * @return int|null
     */
    public function getCheckNumber()
    {
        return $this->CheckNumber;
    }
    /**
     * Set CheckNumber value
     * @param int $checkNumber
     * @return \StructType\CheckInput
     */
    public function setCheckNumber($checkNumber = null)
    {
        // validation for constraint: int
        if (!is_null($checkNumber) && !(is_int($checkNumber) || ctype_digit($checkNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($checkNumber, true), gettype($checkNumber)), __LINE__);
        }
        $this->CheckNumber = $checkNumber;
        return $this;
    }
    /**
     * Get Routing value
     * @return string|null
     */
    public function getRouting()
    {
        return $this->Routing;
    }
    /**
     * Set Routing value
     * @param string $routing
     * @return \StructType\CheckInput
     */
    public function setRouting($routing = null)
    {
        // validation for constraint: string
        if (!is_null($routing) && !is_string($routing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routing, true), gettype($routing)), __LINE__);
        }
        $this->Routing = $routing;
        return $this;
    }
    /**
     * Get Account value
     * @return string|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param string $account
     * @return \StructType\CheckInput
     */
    public function setAccount($account = null)
    {
        // validation for constraint: string
        if (!is_null($account) && !is_string($account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($account, true), gettype($account)), __LINE__);
        }
        $this->Account = $account;
        return $this;
    }
    /**
     * Get AccountType value
     * @return string|null
     */
    public function getAccountType()
    {
        return $this->AccountType;
    }
    /**
     * Set AccountType value
     * @param string $accountType
     * @return \StructType\CheckInput
     */
    public function setAccountType($accountType = null)
    {
        // validation for constraint: string
        if (!is_null($accountType) && !is_string($accountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountType, true), gettype($accountType)), __LINE__);
        }
        $this->AccountType = $accountType;
        return $this;
    }
}
