<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BatchesOutput StructType
 * @subpackage Structs
 */
class BatchesOutput extends AbstractStructBase
{
    /**
     * The MerchantID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MerchantID;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * The BatchNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BatchNumber;
    /**
     * The NetAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $NetAmount;
    /**
     * The TransCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransCount;
    /**
     * Constructor method for BatchesOutput
     * @uses BatchesOutput::setMerchantID()
     * @uses BatchesOutput::setDate()
     * @uses BatchesOutput::setBatchNumber()
     * @uses BatchesOutput::setNetAmount()
     * @uses BatchesOutput::setTransCount()
     * @param string $merchantID
     * @param string $date
     * @param string $batchNumber
     * @param float $netAmount
     * @param string $transCount
     */
    public function __construct($merchantID = null, $date = null, $batchNumber = null, $netAmount = null, $transCount = null)
    {
        $this
            ->setMerchantID($merchantID)
            ->setDate($date)
            ->setBatchNumber($batchNumber)
            ->setNetAmount($netAmount)
            ->setTransCount($transCount);
    }
    /**
     * Get MerchantID value
     * @return string|null
     */
    public function getMerchantID()
    {
        return $this->MerchantID;
    }
    /**
     * Set MerchantID value
     * @param string $merchantID
     * @return \StructType\BatchesOutput
     */
    public function setMerchantID($merchantID = null)
    {
        // validation for constraint: string
        if (!is_null($merchantID) && !is_string($merchantID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantID, true), gettype($merchantID)), __LINE__);
        }
        $this->MerchantID = $merchantID;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\BatchesOutput
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get BatchNumber value
     * @return string|null
     */
    public function getBatchNumber()
    {
        return $this->BatchNumber;
    }
    /**
     * Set BatchNumber value
     * @param string $batchNumber
     * @return \StructType\BatchesOutput
     */
    public function setBatchNumber($batchNumber = null)
    {
        // validation for constraint: string
        if (!is_null($batchNumber) && !is_string($batchNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchNumber, true), gettype($batchNumber)), __LINE__);
        }
        $this->BatchNumber = $batchNumber;
        return $this;
    }
    /**
     * Get NetAmount value
     * @return float|null
     */
    public function getNetAmount()
    {
        return $this->NetAmount;
    }
    /**
     * Set NetAmount value
     * @param float $netAmount
     * @return \StructType\BatchesOutput
     */
    public function setNetAmount($netAmount = null)
    {
        // validation for constraint: float
        if (!is_null($netAmount) && !(is_float($netAmount) || is_numeric($netAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($netAmount, true), gettype($netAmount)), __LINE__);
        }
        $this->NetAmount = $netAmount;
        return $this;
    }
    /**
     * Get TransCount value
     * @return string|null
     */
    public function getTransCount()
    {
        return $this->TransCount;
    }
    /**
     * Set TransCount value
     * @param string $transCount
     * @return \StructType\BatchesOutput
     */
    public function setTransCount($transCount = null)
    {
        // validation for constraint: string
        if (!is_null($transCount) && !is_string($transCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transCount, true), gettype($transCount)), __LINE__);
        }
        $this->TransCount = $transCount;
        return $this;
    }
}
