<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BatchUploadStatus StructType
 * @subpackage Structs
 */
class BatchUploadStatus extends AbstractStructBase
{
    /**
     * The UploadRefNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UploadRefNum;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The Started
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Started;
    /**
     * The Finished
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Finished;
    /**
     * The Transactions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Transactions;
    /**
     * The Remaining
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Remaining;
    /**
     * The Approved
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Approved;
    /**
     * The Declined
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Declined;
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Errors;
    /**
     * Constructor method for BatchUploadStatus
     * @uses BatchUploadStatus::setUploadRefNum()
     * @uses BatchUploadStatus::setStatus()
     * @uses BatchUploadStatus::setStarted()
     * @uses BatchUploadStatus::setFinished()
     * @uses BatchUploadStatus::setTransactions()
     * @uses BatchUploadStatus::setRemaining()
     * @uses BatchUploadStatus::setApproved()
     * @uses BatchUploadStatus::setDeclined()
     * @uses BatchUploadStatus::setErrors()
     * @param int $uploadRefNum
     * @param string $status
     * @param string $started
     * @param string $finished
     * @param int $transactions
     * @param int $remaining
     * @param string $approved
     * @param string $declined
     * @param string $errors
     */
    public function __construct($uploadRefNum = null, $status = null, $started = null, $finished = null, $transactions = null, $remaining = null, $approved = null, $declined = null, $errors = null)
    {
        $this
            ->setUploadRefNum($uploadRefNum)
            ->setStatus($status)
            ->setStarted($started)
            ->setFinished($finished)
            ->setTransactions($transactions)
            ->setRemaining($remaining)
            ->setApproved($approved)
            ->setDeclined($declined)
            ->setErrors($errors);
    }
    /**
     * Get UploadRefNum value
     * @return int
     */
    public function getUploadRefNum()
    {
        return $this->UploadRefNum;
    }
    /**
     * Set UploadRefNum value
     * @param int $uploadRefNum
     * @return \StructType\BatchUploadStatus
     */
    public function setUploadRefNum($uploadRefNum = null)
    {
        // validation for constraint: int
        if (!is_null($uploadRefNum) && !(is_int($uploadRefNum) || ctype_digit($uploadRefNum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($uploadRefNum, true), gettype($uploadRefNum)), __LINE__);
        }
        $this->UploadRefNum = $uploadRefNum;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\BatchUploadStatus
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Started value
     * @return string
     */
    public function getStarted()
    {
        return $this->Started;
    }
    /**
     * Set Started value
     * @param string $started
     * @return \StructType\BatchUploadStatus
     */
    public function setStarted($started = null)
    {
        // validation for constraint: string
        if (!is_null($started) && !is_string($started)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($started, true), gettype($started)), __LINE__);
        }
        $this->Started = $started;
        return $this;
    }
    /**
     * Get Finished value
     * @return string
     */
    public function getFinished()
    {
        return $this->Finished;
    }
    /**
     * Set Finished value
     * @param string $finished
     * @return \StructType\BatchUploadStatus
     */
    public function setFinished($finished = null)
    {
        // validation for constraint: string
        if (!is_null($finished) && !is_string($finished)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($finished, true), gettype($finished)), __LINE__);
        }
        $this->Finished = $finished;
        return $this;
    }
    /**
     * Get Transactions value
     * @return int
     */
    public function getTransactions()
    {
        return $this->Transactions;
    }
    /**
     * Set Transactions value
     * @param int $transactions
     * @return \StructType\BatchUploadStatus
     */
    public function setTransactions($transactions = null)
    {
        // validation for constraint: int
        if (!is_null($transactions) && !(is_int($transactions) || ctype_digit($transactions))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactions, true), gettype($transactions)), __LINE__);
        }
        $this->Transactions = $transactions;
        return $this;
    }
    /**
     * Get Remaining value
     * @return int
     */
    public function getRemaining()
    {
        return $this->Remaining;
    }
    /**
     * Set Remaining value
     * @param int $remaining
     * @return \StructType\BatchUploadStatus
     */
    public function setRemaining($remaining = null)
    {
        // validation for constraint: int
        if (!is_null($remaining) && !(is_int($remaining) || ctype_digit($remaining))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($remaining, true), gettype($remaining)), __LINE__);
        }
        $this->Remaining = $remaining;
        return $this;
    }
    /**
     * Get Approved value
     * @return string
     */
    public function getApproved()
    {
        return $this->Approved;
    }
    /**
     * Set Approved value
     * @param string $approved
     * @return \StructType\BatchUploadStatus
     */
    public function setApproved($approved = null)
    {
        // validation for constraint: string
        if (!is_null($approved) && !is_string($approved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approved, true), gettype($approved)), __LINE__);
        }
        $this->Approved = $approved;
        return $this;
    }
    /**
     * Get Declined value
     * @return string
     */
    public function getDeclined()
    {
        return $this->Declined;
    }
    /**
     * Set Declined value
     * @param string $declined
     * @return \StructType\BatchUploadStatus
     */
    public function setDeclined($declined = null)
    {
        // validation for constraint: string
        if (!is_null($declined) && !is_string($declined)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($declined, true), gettype($declined)), __LINE__);
        }
        $this->Declined = $declined;
        return $this;
    }
    /**
     * Get Errors value
     * @return string
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param string $errors
     * @return \StructType\BatchUploadStatus
     */
    public function setErrors($errors = null)
    {
        // validation for constraint: string
        if (!is_null($errors) && !is_string($errors)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errors, true), gettype($errors)), __LINE__);
        }
        $this->Errors = $errors;
        return $this;
    }
}
