<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BANKCARD_PHONE_AUTH_POST StructType
 * @subpackage Structs
 */
class BANKCARD_PHONE_AUTH_POST extends AbstractStructBase
{
    /**
     * The MerchantID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MerchantID;
    /**
     * The HashInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\HashInput
     */
    public $HashInfo;
    /**
     * The ClientIP
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientIP;
    /**
     * The AuthCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AuthCode;
    /**
     * The ChargeDetailInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ChargeDetailInput
     */
    public $ChargeDetailInfo;
    /**
     * The BillingDetailInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CustDetailInput
     */
    public $BillingDetailInfo;
    /**
     * The ShippingDetailInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CustDetailInput
     */
    public $ShippingDetailInfo;
    /**
     * Constructor method for BANKCARD_PHONE_AUTH_POST
     * @uses BANKCARD_PHONE_AUTH_POST::setMerchantID()
     * @uses BANKCARD_PHONE_AUTH_POST::setHashInfo()
     * @uses BANKCARD_PHONE_AUTH_POST::setClientIP()
     * @uses BANKCARD_PHONE_AUTH_POST::setAuthCode()
     * @uses BANKCARD_PHONE_AUTH_POST::setChargeDetailInfo()
     * @uses BANKCARD_PHONE_AUTH_POST::setBillingDetailInfo()
     * @uses BANKCARD_PHONE_AUTH_POST::setShippingDetailInfo()
     * @param string $merchantID
     * @param \StructType\HashInput $hashInfo
     * @param string $clientIP
     * @param string $authCode
     * @param \StructType\ChargeDetailInput $chargeDetailInfo
     * @param \StructType\CustDetailInput $billingDetailInfo
     * @param \StructType\CustDetailInput $shippingDetailInfo
     */
    public function __construct($merchantID = null, \StructType\HashInput $hashInfo = null, $clientIP = null, $authCode = null, \StructType\ChargeDetailInput $chargeDetailInfo = null, \StructType\CustDetailInput $billingDetailInfo = null, \StructType\CustDetailInput $shippingDetailInfo = null)
    {
        $this
            ->setMerchantID($merchantID)
            ->setHashInfo($hashInfo)
            ->setClientIP($clientIP)
            ->setAuthCode($authCode)
            ->setChargeDetailInfo($chargeDetailInfo)
            ->setBillingDetailInfo($billingDetailInfo)
            ->setShippingDetailInfo($shippingDetailInfo);
    }
    /**
     * Get MerchantID value
     * @return string
     */
    public function getMerchantID()
    {
        return $this->MerchantID;
    }
    /**
     * Set MerchantID value
     * @param string $merchantID
     * @return \StructType\BANKCARD_PHONE_AUTH_POST
     */
    public function setMerchantID($merchantID = null)
    {
        // validation for constraint: string
        if (!is_null($merchantID) && !is_string($merchantID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantID, true), gettype($merchantID)), __LINE__);
        }
        $this->MerchantID = $merchantID;
        return $this;
    }
    /**
     * Get HashInfo value
     * @return \StructType\HashInput
     */
    public function getHashInfo()
    {
        return $this->HashInfo;
    }
    /**
     * Set HashInfo value
     * @param \StructType\HashInput $hashInfo
     * @return \StructType\BANKCARD_PHONE_AUTH_POST
     */
    public function setHashInfo(\StructType\HashInput $hashInfo = null)
    {
        $this->HashInfo = $hashInfo;
        return $this;
    }
    /**
     * Get ClientIP value
     * @return string|null
     */
    public function getClientIP()
    {
        return $this->ClientIP;
    }
    /**
     * Set ClientIP value
     * @param string $clientIP
     * @return \StructType\BANKCARD_PHONE_AUTH_POST
     */
    public function setClientIP($clientIP = null)
    {
        // validation for constraint: string
        if (!is_null($clientIP) && !is_string($clientIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientIP, true), gettype($clientIP)), __LINE__);
        }
        $this->ClientIP = $clientIP;
        return $this;
    }
    /**
     * Get AuthCode value
     * @return string|null
     */
    public function getAuthCode()
    {
        return $this->AuthCode;
    }
    /**
     * Set AuthCode value
     * @param string $authCode
     * @return \StructType\BANKCARD_PHONE_AUTH_POST
     */
    public function setAuthCode($authCode = null)
    {
        // validation for constraint: string
        if (!is_null($authCode) && !is_string($authCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authCode, true), gettype($authCode)), __LINE__);
        }
        $this->AuthCode = $authCode;
        return $this;
    }
    /**
     * Get ChargeDetailInfo value
     * @return \StructType\ChargeDetailInput|null
     */
    public function getChargeDetailInfo()
    {
        return $this->ChargeDetailInfo;
    }
    /**
     * Set ChargeDetailInfo value
     * @param \StructType\ChargeDetailInput $chargeDetailInfo
     * @return \StructType\BANKCARD_PHONE_AUTH_POST
     */
    public function setChargeDetailInfo(\StructType\ChargeDetailInput $chargeDetailInfo = null)
    {
        $this->ChargeDetailInfo = $chargeDetailInfo;
        return $this;
    }
    /**
     * Get BillingDetailInfo value
     * @return \StructType\CustDetailInput|null
     */
    public function getBillingDetailInfo()
    {
        return $this->BillingDetailInfo;
    }
    /**
     * Set BillingDetailInfo value
     * @param \StructType\CustDetailInput $billingDetailInfo
     * @return \StructType\BANKCARD_PHONE_AUTH_POST
     */
    public function setBillingDetailInfo(\StructType\CustDetailInput $billingDetailInfo = null)
    {
        $this->BillingDetailInfo = $billingDetailInfo;
        return $this;
    }
    /**
     * Get ShippingDetailInfo value
     * @return \StructType\CustDetailInput|null
     */
    public function getShippingDetailInfo()
    {
        return $this->ShippingDetailInfo;
    }
    /**
     * Set ShippingDetailInfo value
     * @param \StructType\CustDetailInput $shippingDetailInfo
     * @return \StructType\BANKCARD_PHONE_AUTH_POST
     */
    public function setShippingDetailInfo(\StructType\CustDetailInput $shippingDetailInfo = null)
    {
        $this->ShippingDetailInfo = $shippingDetailInfo;
        return $this;
    }
}
