<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BANKCARD_DEL_CUSTOMER_PAYMENT_METHOD StructType
 * @subpackage Structs
 */
class BANKCARD_DEL_CUSTOMER_PAYMENT_METHOD extends AbstractStructBase
{
    /**
     * The MerchantID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MerchantID;
    /**
     * The HashInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\HashInput
     */
    public $HashInfo;
    /**
     * The ClientIP
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientIP;
    /**
     * The CustDBNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustDBNum;
    /**
     * The MethodID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MethodID;
    /**
     * Constructor method for BANKCARD_DEL_CUSTOMER_PAYMENT_METHOD
     * @uses BANKCARD_DEL_CUSTOMER_PAYMENT_METHOD::setMerchantID()
     * @uses BANKCARD_DEL_CUSTOMER_PAYMENT_METHOD::setHashInfo()
     * @uses BANKCARD_DEL_CUSTOMER_PAYMENT_METHOD::setClientIP()
     * @uses BANKCARD_DEL_CUSTOMER_PAYMENT_METHOD::setCustDBNum()
     * @uses BANKCARD_DEL_CUSTOMER_PAYMENT_METHOD::setMethodID()
     * @param string $merchantID
     * @param \StructType\HashInput $hashInfo
     * @param string $clientIP
     * @param string $custDBNum
     * @param string $methodID
     */
    public function __construct($merchantID = null, \StructType\HashInput $hashInfo = null, $clientIP = null, $custDBNum = null, $methodID = null)
    {
        $this
            ->setMerchantID($merchantID)
            ->setHashInfo($hashInfo)
            ->setClientIP($clientIP)
            ->setCustDBNum($custDBNum)
            ->setMethodID($methodID);
    }
    /**
     * Get MerchantID value
     * @return string
     */
    public function getMerchantID()
    {
        return $this->MerchantID;
    }
    /**
     * Set MerchantID value
     * @param string $merchantID
     * @return \StructType\BANKCARD_DEL_CUSTOMER_PAYMENT_METHOD
     */
    public function setMerchantID($merchantID = null)
    {
        // validation for constraint: string
        if (!is_null($merchantID) && !is_string($merchantID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantID, true), gettype($merchantID)), __LINE__);
        }
        $this->MerchantID = $merchantID;
        return $this;
    }
    /**
     * Get HashInfo value
     * @return \StructType\HashInput
     */
    public function getHashInfo()
    {
        return $this->HashInfo;
    }
    /**
     * Set HashInfo value
     * @param \StructType\HashInput $hashInfo
     * @return \StructType\BANKCARD_DEL_CUSTOMER_PAYMENT_METHOD
     */
    public function setHashInfo(\StructType\HashInput $hashInfo = null)
    {
        $this->HashInfo = $hashInfo;
        return $this;
    }
    /**
     * Get ClientIP value
     * @return string|null
     */
    public function getClientIP()
    {
        return $this->ClientIP;
    }
    /**
     * Set ClientIP value
     * @param string $clientIP
     * @return \StructType\BANKCARD_DEL_CUSTOMER_PAYMENT_METHOD
     */
    public function setClientIP($clientIP = null)
    {
        // validation for constraint: string
        if (!is_null($clientIP) && !is_string($clientIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientIP, true), gettype($clientIP)), __LINE__);
        }
        $this->ClientIP = $clientIP;
        return $this;
    }
    /**
     * Get CustDBNum value
     * @return string|null
     */
    public function getCustDBNum()
    {
        return $this->CustDBNum;
    }
    /**
     * Set CustDBNum value
     * @param string $custDBNum
     * @return \StructType\BANKCARD_DEL_CUSTOMER_PAYMENT_METHOD
     */
    public function setCustDBNum($custDBNum = null)
    {
        // validation for constraint: string
        if (!is_null($custDBNum) && !is_string($custDBNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($custDBNum, true), gettype($custDBNum)), __LINE__);
        }
        $this->CustDBNum = $custDBNum;
        return $this;
    }
    /**
     * Get MethodID value
     * @return string|null
     */
    public function getMethodID()
    {
        return $this->MethodID;
    }
    /**
     * Set MethodID value
     * @param string $methodID
     * @return \StructType\BANKCARD_DEL_CUSTOMER_PAYMENT_METHOD
     */
    public function setMethodID($methodID = null)
    {
        // validation for constraint: string
        if (!is_null($methodID) && !is_string($methodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($methodID, true), gettype($methodID)), __LINE__);
        }
        $this->MethodID = $methodID;
        return $this;
    }
}
