<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BANKCARD_CUSTOMER_PRIOR_AUTH_SALE StructType
 * @subpackage Structs
 */
class BANKCARD_CUSTOMER_PRIOR_AUTH_SALE extends AbstractStructBase
{
    /**
     * The MerchantID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MerchantID;
    /**
     * The HashInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\HashInput
     */
    public $HashInfo;
    /**
     * The ClientIP
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientIP;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReferenceNumber;
    /**
     * The CustomerChargeInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CustomerChargeInput
     */
    public $CustomerChargeInfo;
    /**
     * The ItemDetailInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ItemDetailInput[]
     */
    public $ItemDetailInfo;
    /**
     * Constructor method for BANKCARD_CUSTOMER_PRIOR_AUTH_SALE
     * @uses BANKCARD_CUSTOMER_PRIOR_AUTH_SALE::setMerchantID()
     * @uses BANKCARD_CUSTOMER_PRIOR_AUTH_SALE::setHashInfo()
     * @uses BANKCARD_CUSTOMER_PRIOR_AUTH_SALE::setClientIP()
     * @uses BANKCARD_CUSTOMER_PRIOR_AUTH_SALE::setReferenceNumber()
     * @uses BANKCARD_CUSTOMER_PRIOR_AUTH_SALE::setCustomerChargeInfo()
     * @uses BANKCARD_CUSTOMER_PRIOR_AUTH_SALE::setItemDetailInfo()
     * @param string $merchantID
     * @param \StructType\HashInput $hashInfo
     * @param string $clientIP
     * @param string $referenceNumber
     * @param \StructType\CustomerChargeInput $customerChargeInfo
     * @param \StructType\ItemDetailInput[] $itemDetailInfo
     */
    public function __construct($merchantID = null, \StructType\HashInput $hashInfo = null, $clientIP = null, $referenceNumber = null, \StructType\CustomerChargeInput $customerChargeInfo = null, array $itemDetailInfo = array())
    {
        $this
            ->setMerchantID($merchantID)
            ->setHashInfo($hashInfo)
            ->setClientIP($clientIP)
            ->setReferenceNumber($referenceNumber)
            ->setCustomerChargeInfo($customerChargeInfo)
            ->setItemDetailInfo($itemDetailInfo);
    }
    /**
     * Get MerchantID value
     * @return string
     */
    public function getMerchantID()
    {
        return $this->MerchantID;
    }
    /**
     * Set MerchantID value
     * @param string $merchantID
     * @return \StructType\BANKCARD_CUSTOMER_PRIOR_AUTH_SALE
     */
    public function setMerchantID($merchantID = null)
    {
        // validation for constraint: string
        if (!is_null($merchantID) && !is_string($merchantID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantID, true), gettype($merchantID)), __LINE__);
        }
        $this->MerchantID = $merchantID;
        return $this;
    }
    /**
     * Get HashInfo value
     * @return \StructType\HashInput
     */
    public function getHashInfo()
    {
        return $this->HashInfo;
    }
    /**
     * Set HashInfo value
     * @param \StructType\HashInput $hashInfo
     * @return \StructType\BANKCARD_CUSTOMER_PRIOR_AUTH_SALE
     */
    public function setHashInfo(\StructType\HashInput $hashInfo = null)
    {
        $this->HashInfo = $hashInfo;
        return $this;
    }
    /**
     * Get ClientIP value
     * @return string|null
     */
    public function getClientIP()
    {
        return $this->ClientIP;
    }
    /**
     * Set ClientIP value
     * @param string $clientIP
     * @return \StructType\BANKCARD_CUSTOMER_PRIOR_AUTH_SALE
     */
    public function setClientIP($clientIP = null)
    {
        // validation for constraint: string
        if (!is_null($clientIP) && !is_string($clientIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientIP, true), gettype($clientIP)), __LINE__);
        }
        $this->ClientIP = $clientIP;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param string $referenceNumber
     * @return \StructType\BANKCARD_CUSTOMER_PRIOR_AUTH_SALE
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get CustomerChargeInfo value
     * @return \StructType\CustomerChargeInput|null
     */
    public function getCustomerChargeInfo()
    {
        return $this->CustomerChargeInfo;
    }
    /**
     * Set CustomerChargeInfo value
     * @param \StructType\CustomerChargeInput $customerChargeInfo
     * @return \StructType\BANKCARD_CUSTOMER_PRIOR_AUTH_SALE
     */
    public function setCustomerChargeInfo(\StructType\CustomerChargeInput $customerChargeInfo = null)
    {
        $this->CustomerChargeInfo = $customerChargeInfo;
        return $this;
    }
    /**
     * Get ItemDetailInfo value
     * @return \StructType\ItemDetailInput[]|null
     */
    public function getItemDetailInfo()
    {
        return $this->ItemDetailInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setItemDetailInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemDetailInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemDetailInfoForArrayConstraintsFromSetItemDetailInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bANKCARD_CUSTOMER_PRIOR_AUTH_SALEItemDetailInfoItem) {
            // validation for constraint: itemType
            if (!$bANKCARD_CUSTOMER_PRIOR_AUTH_SALEItemDetailInfoItem instanceof \StructType\ItemDetailInput) {
                $invalidValues[] = is_object($bANKCARD_CUSTOMER_PRIOR_AUTH_SALEItemDetailInfoItem) ? get_class($bANKCARD_CUSTOMER_PRIOR_AUTH_SALEItemDetailInfoItem) : sprintf('%s(%s)', gettype($bANKCARD_CUSTOMER_PRIOR_AUTH_SALEItemDetailInfoItem), var_export($bANKCARD_CUSTOMER_PRIOR_AUTH_SALEItemDetailInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemDetailInfo property can only contain items of type \StructType\ItemDetailInput, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItemDetailInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemDetailInput[] $itemDetailInfo
     * @return \StructType\BANKCARD_CUSTOMER_PRIOR_AUTH_SALE
     */
    public function setItemDetailInfo(array $itemDetailInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($itemDetailInfoArrayErrorMessage = self::validateItemDetailInfoForArrayConstraintsFromSetItemDetailInfo($itemDetailInfo))) {
            throw new \InvalidArgumentException($itemDetailInfoArrayErrorMessage, __LINE__);
        }
        $this->ItemDetailInfo = $itemDetailInfo;
        return $this;
    }
    /**
     * Add item to ItemDetailInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemDetailInput $item
     * @return \StructType\BANKCARD_CUSTOMER_PRIOR_AUTH_SALE
     */
    public function addToItemDetailInfo(\StructType\ItemDetailInput $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemDetailInput) {
            throw new \InvalidArgumentException(sprintf('The ItemDetailInfo property can only contain items of type \StructType\ItemDetailInput, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemDetailInfo[] = $item;
        return $this;
    }
}
