<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BANKCARD_ADD_CUSTOMER StructType
 * @subpackage Structs
 */
class BANKCARD_ADD_CUSTOMER extends AbstractStructBase
{
    /**
     * The MerchantID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MerchantID;
    /**
     * The HashInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\HashInput
     */
    public $HashInfo;
    /**
     * The ClientIP
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientIP;
    /**
     * The CustomerInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CustomerInput
     */
    public $CustomerInfo;
    /**
     * Constructor method for BANKCARD_ADD_CUSTOMER
     * @uses BANKCARD_ADD_CUSTOMER::setMerchantID()
     * @uses BANKCARD_ADD_CUSTOMER::setHashInfo()
     * @uses BANKCARD_ADD_CUSTOMER::setClientIP()
     * @uses BANKCARD_ADD_CUSTOMER::setCustomerInfo()
     * @param string $merchantID
     * @param \StructType\HashInput $hashInfo
     * @param string $clientIP
     * @param \StructType\CustomerInput $customerInfo
     */
    public function __construct($merchantID = null, \StructType\HashInput $hashInfo = null, $clientIP = null, \StructType\CustomerInput $customerInfo = null)
    {
        $this
            ->setMerchantID($merchantID)
            ->setHashInfo($hashInfo)
            ->setClientIP($clientIP)
            ->setCustomerInfo($customerInfo);
    }
    /**
     * Get MerchantID value
     * @return string
     */
    public function getMerchantID()
    {
        return $this->MerchantID;
    }
    /**
     * Set MerchantID value
     * @param string $merchantID
     * @return \StructType\BANKCARD_ADD_CUSTOMER
     */
    public function setMerchantID($merchantID = null)
    {
        // validation for constraint: string
        if (!is_null($merchantID) && !is_string($merchantID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantID, true), gettype($merchantID)), __LINE__);
        }
        $this->MerchantID = $merchantID;
        return $this;
    }
    /**
     * Get HashInfo value
     * @return \StructType\HashInput
     */
    public function getHashInfo()
    {
        return $this->HashInfo;
    }
    /**
     * Set HashInfo value
     * @param \StructType\HashInput $hashInfo
     * @return \StructType\BANKCARD_ADD_CUSTOMER
     */
    public function setHashInfo(\StructType\HashInput $hashInfo = null)
    {
        $this->HashInfo = $hashInfo;
        return $this;
    }
    /**
     * Get ClientIP value
     * @return string|null
     */
    public function getClientIP()
    {
        return $this->ClientIP;
    }
    /**
     * Set ClientIP value
     * @param string $clientIP
     * @return \StructType\BANKCARD_ADD_CUSTOMER
     */
    public function setClientIP($clientIP = null)
    {
        // validation for constraint: string
        if (!is_null($clientIP) && !is_string($clientIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientIP, true), gettype($clientIP)), __LINE__);
        }
        $this->ClientIP = $clientIP;
        return $this;
    }
    /**
     * Get CustomerInfo value
     * @return \StructType\CustomerInput|null
     */
    public function getCustomerInfo()
    {
        return $this->CustomerInfo;
    }
    /**
     * Set CustomerInfo value
     * @param \StructType\CustomerInput $customerInfo
     * @return \StructType\BANKCARD_ADD_CUSTOMER
     */
    public function setCustomerInfo(\StructType\CustomerInput $customerInfo = null)
    {
        $this->CustomerInfo = $customerInfo;
        return $this;
    }
}
