<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for BANKCHECKSALE ServiceType
 * @subpackage Services
 */
class BANKCHECKSALE extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named BANKCHECK_SALE
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BANKCHECK_SALE $parameters
     * @return \StructType\BANKCHECK_SALEResponse|bool
     */
    public function BANKCHECK_SALE(\StructType\BANKCHECK_SALE $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->BANKCHECK_SALE($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\BANKCHECK_SALEResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
