<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentMethodInput StructType
 * @subpackage Structs
 */
class PaymentMethodInput extends AbstractStructBase
{
    /**
     * The CreditCardInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CreditCardInput
     */
    public $CreditCardInfo;
    /**
     * The CheckInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CheckInput
     */
    public $CheckInfo;
    /**
     * The MethodID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MethodID;
    /**
     * The MethodName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MethodName;
    /**
     * Constructor method for PaymentMethodInput
     * @uses PaymentMethodInput::setCreditCardInfo()
     * @uses PaymentMethodInput::setCheckInfo()
     * @uses PaymentMethodInput::setMethodID()
     * @uses PaymentMethodInput::setMethodName()
     * @param \StructType\CreditCardInput $creditCardInfo
     * @param \StructType\CheckInput $checkInfo
     * @param string $methodID
     * @param string $methodName
     */
    public function __construct(\StructType\CreditCardInput $creditCardInfo = null, \StructType\CheckInput $checkInfo = null, $methodID = null, $methodName = null)
    {
        $this
            ->setCreditCardInfo($creditCardInfo)
            ->setCheckInfo($checkInfo)
            ->setMethodID($methodID)
            ->setMethodName($methodName);
    }
    /**
     * Get CreditCardInfo value
     * @return \StructType\CreditCardInput|null
     */
    public function getCreditCardInfo()
    {
        return $this->CreditCardInfo;
    }
    /**
     * Set CreditCardInfo value
     * @param \StructType\CreditCardInput $creditCardInfo
     * @return \StructType\PaymentMethodInput
     */
    public function setCreditCardInfo(\StructType\CreditCardInput $creditCardInfo = null)
    {
        $this->CreditCardInfo = $creditCardInfo;
        return $this;
    }
    /**
     * Get CheckInfo value
     * @return \StructType\CheckInput|null
     */
    public function getCheckInfo()
    {
        return $this->CheckInfo;
    }
    /**
     * Set CheckInfo value
     * @param \StructType\CheckInput $checkInfo
     * @return \StructType\PaymentMethodInput
     */
    public function setCheckInfo(\StructType\CheckInput $checkInfo = null)
    {
        $this->CheckInfo = $checkInfo;
        return $this;
    }
    /**
     * Get MethodID value
     * @return string|null
     */
    public function getMethodID()
    {
        return $this->MethodID;
    }
    /**
     * Set MethodID value
     * @param string $methodID
     * @return \StructType\PaymentMethodInput
     */
    public function setMethodID($methodID = null)
    {
        // validation for constraint: string
        if (!is_null($methodID) && !is_string($methodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($methodID, true), gettype($methodID)), __LINE__);
        }
        $this->MethodID = $methodID;
        return $this;
    }
    /**
     * Get MethodName value
     * @return string|null
     */
    public function getMethodName()
    {
        return $this->MethodName;
    }
    /**
     * Set MethodName value
     * @param string $methodName
     * @return \StructType\PaymentMethodInput
     */
    public function setMethodName($methodName = null)
    {
        // validation for constraint: string
        if (!is_null($methodName) && !is_string($methodName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($methodName, true), gettype($methodName)), __LINE__);
        }
        $this->MethodName = $methodName;
        return $this;
    }
}
