<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HashInput StructType
 * @subpackage Structs
 */
class HashInput extends AbstractStructBase
{
    /**
     * The PinHash
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PinHash;
    /**
     * The HashType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $HashType;
    /**
     * The HashSeed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $HashSeed;
    /**
     * The Sourcekey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Sourcekey;
    /**
     * Constructor method for HashInput
     * @uses HashInput::setPinHash()
     * @uses HashInput::setHashType()
     * @uses HashInput::setHashSeed()
     * @uses HashInput::setSourcekey()
     * @param string $pinHash
     * @param string $hashType
     * @param string $hashSeed
     * @param string $sourcekey
     */
    public function __construct($pinHash = null, $hashType = null, $hashSeed = null, $sourcekey = null)
    {
        $this
            ->setPinHash($pinHash)
            ->setHashType($hashType)
            ->setHashSeed($hashSeed)
            ->setSourcekey($sourcekey);
    }
    /**
     * Get PinHash value
     * @return string
     */
    public function getPinHash()
    {
        return $this->PinHash;
    }
    /**
     * Set PinHash value
     * @param string $pinHash
     * @return \StructType\HashInput
     */
    public function setPinHash($pinHash = null)
    {
        // validation for constraint: string
        if (!is_null($pinHash) && !is_string($pinHash)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pinHash, true), gettype($pinHash)), __LINE__);
        }
        $this->PinHash = $pinHash;
        return $this;
    }
    /**
     * Get HashType value
     * @return string
     */
    public function getHashType()
    {
        return $this->HashType;
    }
    /**
     * Set HashType value
     * @param string $hashType
     * @return \StructType\HashInput
     */
    public function setHashType($hashType = null)
    {
        // validation for constraint: string
        if (!is_null($hashType) && !is_string($hashType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hashType, true), gettype($hashType)), __LINE__);
        }
        $this->HashType = $hashType;
        return $this;
    }
    /**
     * Get HashSeed value
     * @return string
     */
    public function getHashSeed()
    {
        return $this->HashSeed;
    }
    /**
     * Set HashSeed value
     * @param string $hashSeed
     * @return \StructType\HashInput
     */
    public function setHashSeed($hashSeed = null)
    {
        // validation for constraint: string
        if (!is_null($hashSeed) && !is_string($hashSeed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hashSeed, true), gettype($hashSeed)), __LINE__);
        }
        $this->HashSeed = $hashSeed;
        return $this;
    }
    /**
     * Get Sourcekey value
     * @return string|null
     */
    public function getSourcekey()
    {
        return $this->Sourcekey;
    }
    /**
     * Set Sourcekey value
     * @param string $sourcekey
     * @return \StructType\HashInput
     */
    public function setSourcekey($sourcekey = null)
    {
        // validation for constraint: string
        if (!is_null($sourcekey) && !is_string($sourcekey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourcekey, true), gettype($sourcekey)), __LINE__);
        }
        $this->Sourcekey = $sourcekey;
        return $this;
    }
}
